/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.hana.connectivity.handler;

import java.sql.Connection;

public class DataSourceHandlerFactory {
	
	private static DataSourceHandlerFactory dsHandlerFactory = null;
	public static DataSourceHandlerFactory getInstance(){
		
		if(dsHandlerFactory == null){
			dsHandlerFactory = new DataSourceHandlerFactory();
		}
		
		return dsHandlerFactory;
	}
	
	public CDSDataSourceHandler getCDSHandler(Connection conn, String nameSpace){
		CDSDataSourceHandler cdsHandler = new CDSDataSourceHandlerImpl(conn, nameSpace);
		return cdsHandler;
	}
	
}
