/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.olingo.odata2.client.core.edm.Impl;

import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmType;

/**
 *  Objects of this class represent ComplexProperty
 */
public class EdmComplexPropertyImpl extends EdmPropertyImpl {



  @Override
  public EdmType getType() throws EdmException {
    if (edmType == null) {
      edmType = edm.getComplexType(typeName.getNamespace(), typeName.getName());
    }
    if (edmType == null) {
      throw new EdmException(EdmException.TYPEPROBLEM);
    }
    return edmType;
  }


  public boolean isSimple() {
    return false;
  }
  
  @Override
  public String toString() {
    try {
      return edmType.getNamespace()+ Edm.DELIMITER +  edmType.getName();
    } catch (EdmException e) { //NOPMD  - suppressed
      return null; //NOSONAR
    }
  }
}
