/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import java.io.IOException;

import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.edm.EdmTime;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

public class LongTypeAdapter extends TypeAdapter<Long> {
    /**
     * For internal use only by data model classes
     */
    @Override
    public void write( final JsonWriter out, final Long entityValue )
        throws IOException
    {
    	 
    }

    /**
     * For internal use only by data model classes
     */
    @Override
    public Long read( final JsonReader in )
        throws IOException
    {   
    	if (in.peek().equals(JsonToken.NULL)) {
			in.nextNull();
			return null;
		}
        final String jsonDateValue = in.nextString();
        try {
        	
        	if(EdmDateTime.getInstance().validate(jsonDateValue, EdmLiteralKind.JSON,null))
        	{
        		return EdmDateTime.getInstance().valueOfString(jsonDateValue, EdmLiteralKind.JSON, null, Long.class);
        	}
        	else if(EdmTime.getInstance().validate(jsonDateValue, EdmLiteralKind.JSON,null))
        	{
        		return EdmTime.getInstance().valueOfString(jsonDateValue, EdmLiteralKind.JSON, null, Long.class);
        	}
        	else if(EdmDateTimeOffset.getInstance().validate(jsonDateValue, EdmLiteralKind.JSON,null))
        	{
        		return EdmDateTimeOffset.getInstance().valueOfString(jsonDateValue, EdmLiteralKind.JSON, null, Long.class);
        	}
        	else
        	{
        		return null;
        	}            
        }
        catch( final EdmSimpleTypeException e ) {
            return null;
        }
    }
}
