/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpResponse;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.sdk.odatav2.connectivity.batch.ChangeSetResultPart;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataHttpResponseWrapper;
import com.sap.cloud.servicesdk.prov.jacksonutil.JacksonMapper;

public class ODataCreateResult extends  ODataHttpResponseWrapper implements ChangeSetResultPart {

	Map<String, Object> resultData = null;

	public ODataCreateResult(HttpResponse httpResponse, Map<String, Object> map) {
		setResponse(httpResponse);
		this.resultData = map;
	}
	
	 public ODataCreateResult(Map<String, Object> map, Map<String, List<String>> headerMap, int statusCode) {
	    this.resultData = map;
	    super.headersMap = headerMap;
	    super.responseStatusCode = statusCode;
	  }

	/**
	 * Returns the create response as a map.
	 * @return
	 */
		public Map<String, Object> asMap() {
			Map<String, Object> result = new HashMap<>();
			for (Entry<String, Object> property : resultData.entrySet()) {
			 if (property.getValue() instanceof ODataFeed) {// implies we are handling a Navigation property here
					ODataFeed feed = (ODataFeed) property.getValue();
					List<Map<String, Object>> allresult = new ArrayList<Map<String, Object>>();
					for (ODataEntry feedEntry : feed.getEntries()) {				
						allresult.add(mapEntryToMap(feedEntry));					
					}			
					result.put(property.getKey(), allresult);
				}else if (property.getValue() instanceof ODataEntry){
					ODataEntry entryFeed = (ODataEntry) property.getValue();
					Map<String, Object> finalResult = mapEntryToMap(entryFeed);
					result.put(property.getKey(), finalResult);
				}			
				else{
					result.put(property.getKey(), property.getValue());
				}
			}
			return result;
		}
		

		private Map<String, Object> mapEntryToMap(ODataEntry entry) {
			Map<String, Object> finalResult = new HashMap<>();
			for (Entry<String, Object> property : entry.getProperties().entrySet()) {

				if (property.getValue() instanceof ODataFeed) {
					ODataFeed feedExpand = (ODataFeed) property.getValue();
					List<Map<String, Object>> allChildren = new ArrayList<Map<String, Object>>();
					for (ODataEntry feedEntry : feedExpand.getEntries()) {
						allChildren.add(mapEntryToMap(feedEntry));
					}
					finalResult.put(property.getKey(), allChildren);
				} else if (property.getValue() instanceof ODataEntry) {
					ODataEntry entryFeed = (ODataEntry) property.getValue();
					finalResult.put(property.getKey(), mapEntryToMap(entryFeed));
				} else {
					finalResult.put(property.getKey(), property.getValue());
				}
			}
			return finalResult;
		}
	
	/**
	 * Returns the create response as an object of the class passed under parameter t.
	 * @param t
	 * @return
	 */
	public  <T> T as(Class<T> t)  {
		Map<String, Object> finalResult = this.asMap();
		ObjectMapper mapper = JacksonMapper.getMapper();
		
		try {
			@SuppressWarnings("unchecked")
			T pojo = (T) mapper.convertValue(finalResult, Class.forName(t.getTypeName()));
			return pojo;
		} catch (IllegalArgumentException | ClassNotFoundException e) {
			throw new IllegalArgumentException("Exception in POJO Conversion :",  e.getCause());
		} 
		
	}
}
