/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import org.apache.http.client.HttpClient;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;

public interface ODataDeleteRequest {

	/**
	 * Executes the OData Delete request represented by this object.
	 * @param destinationName
	 * @return
	 * @throws ODataException
	 */
	public ODataDeleteResult execute(String destinationName) throws ODataException;

	/**
	 * Executes the OData delete request represented by this object.
	 * @param withDestinationName
	 * @return
	 * @throws ODataException
	 */
	public ODataDeleteResult execute(final WithDestinationName withDestinationName) throws ODataException;
	/**
	 * Execute the OData Delete request using the HTTP Client supplied by
	 * consumer
	 * 
	 * @param providedClient
	 *            HTTP Client provided by the consumer of the API
	 * @return
	 * @throws ODataException
	 */
	public ODataDeleteResult execute(final HttpClient providedClient) throws ODataException;
}

