/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import com.google.gson.GsonBuilder;
import com.sap.cloud.sdk.result.AnnotatedFieldGsonExclusionStrategy;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.result.ElementNameGsonFieldNamingStrategy;

import java.util.Date;
import java.util.Calendar;
import java.util.UUID;

import com.sap.cloud.sdk.odatav2.connectivity.CalenderTypeAdapter;

public final class ODataGsonBuilder
{
    public static GsonBuilder newGsonBuilder()
    {
        return new GsonBuilder()
            .disableHtmlEscaping()
            .setFieldNamingStrategy(new ElementNameGsonFieldNamingStrategy())
            .setExclusionStrategies(new AnnotatedFieldGsonExclusionStrategy<>(ElementName.class))
            .registerTypeAdapterFactory(new StringConstructedTypeAdapterFactory())
            .registerTypeAdapter(UUID.class, new UUIDTypeAdapter())
            .registerTypeAdapter(Calendar.class, new CalenderTypeAdapter())
            .registerTypeAdapter(Date.class, new DateTypeAdapter())
        	.registerTypeAdapter(Long.class, new LongTypeAdapter());
    }
}
