/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import java.io.IOException;
import java.io.InputStream;

import com.sap.cloud.sdk.odatav2.connectivity.batch.ChangeSetResultPart;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataHttpResponseWrapper;

import lombok.Getter;

public class ODataMediaResult extends ODataHttpResponseWrapper implements ChangeSetResultPart {
	@Getter
	private InputStream media;
	private static final String FAILED_LOG_MSG = "Unable to read media resource.";

	/**
	 * Constructs ODataMediaResult object
	 * @param queryResult
	 */	
	ODataMediaResult(ODataQueryResult queryResult) throws ODataException {
		try {
			this.media = queryResult.getHttpResponse().getEntity().getContent();
		} catch (UnsupportedOperationException | IOException e) {
			throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, FAILED_LOG_MSG, e);			
		}
	}	
}
