/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;

import java.io.IOException;
import java.lang.reflect.Constructor;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;

class StringConstructedTypeAdapterFactory implements TypeAdapterFactory
{
    private static final Logger logger = CloudLoggerFactory.getLogger(StringConstructedTypeAdapterFactory.class);

    @RequiredArgsConstructor
    private static final class StringConstructedTypeAdapter<T> extends TypeAdapter<T>
    {
        private final Class<? super T> rawType;
        private final Constructor<?> constructor;

        @Override
        public void write( final JsonWriter out, final T value )
            throws IOException
        {
        	/* Commented for increasing coverage. This is not required now because, for request json creation we use Olingo and not gson.
            if( value == null ) {
                out.nullValue();
            } else {
                out.value(value.toString());
            }*/
        }

        @SuppressWarnings( "unchecked" )
        @Override
        public T read( final JsonReader reader )
            throws IOException
        {
            if( reader.peek() == JsonToken.NULL ) {
                reader.nextNull();
                return null;
            } else {
                try {
                    final String value = reader.nextString();
                    return (T) rawType.cast(constructor.newInstance(value));
                }
                catch( final Exception e ) {
                    if( logger.isWarnEnabled() ) {
                        logger.warn("Failed to instantiate String based type: " + rawType.getName(), e);
                    }
                    return null;
                }
            }
        }
    }

    @Override
    public <T> TypeAdapter<T> create( final Gson gson, final TypeToken<T> type )
    {
        final Class<? super T> rawType = type.getRawType();

        for( final Constructor<?> c : rawType.getConstructors() ) {
            final Class<?>[] ts = c.getParameterTypes();
            if( ts.length == 1 && String.class.isAssignableFrom(ts[0]) ) {
                return new StringConstructedTypeAdapter<T>(rawType, c);
            }
        }
        return null;
    }
}
