/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import java.io.IOException;
import java.util.UUID;

import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.EdmGuid;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

public class UUIDTypeAdapter extends TypeAdapter<UUID> {
	
	/**
	     * For internal use only by data model classes
	     */
	    @Override
	    public UUID read( final JsonReader in )
	        throws IOException
	    {
	    	if (in.peek().equals(JsonToken.NULL)) {
				in.nextNull();
				return null;
			}
	    	
	        final String jsonDateValue = in.nextString();
	        try {
	            return EdmGuid.getInstance().valueOfString(jsonDateValue, EdmLiteralKind.JSON, null, UUID.class);
	        }
	        catch( final EdmSimpleTypeException e ) {
	            return null;
	        }
	    }

		@Override
		public void write(JsonWriter out, UUID entityValue) throws IOException {
			 /*This code is commented out for the sake of coverage. This is currently not required because for request json creating we use Olingo and not Gson.
			  * 
			  * try {
		            out.value(EdmGuid.getInstance().valueToString(entityValue, EdmLiteralKind.JSON, null));
		        }
		        catch( final EdmSimpleTypeException e ) {
		            out.value("");
		        }*/
		}

}
