package com.sap.cloud.sdk.odatav2.connectivity.batch;

import java.io.IOException;

import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;

public interface BatchRequest {

	/**
	 * Executes all the operations in the batch request.
	 * @param destinationName String representing the destination where the batch request will be executed
	 * @throws ODataException If an error occurs during the execution of the batch request
	 */
	public BatchResult execute(String destinationName)
	    throws ODataException;

	/**
   * Executes all the operations in the batch request.
   * @param withDestinationName Object representing the destination where the batch request will be executed
   * @throws ODataException If an error occurs during the execution of the batch request
   */
	public BatchResult execute(final WithDestinationName withDestinationName) 
	    throws ODataException;
	
	/**
	 * Executes all the operations in the batch request.
	 * @param providedClient Custom HttpClient for connecting to the data source
   * @throws ODataException If an error occurs during the execution of the batch request
	 */
    public BatchResult execute(HttpClient providedClient) 
        throws ODataException;
}
