package com.sap.cloud.sdk.odatav2.connectivity.batch;

import java.util.ArrayList;
import java.util.List;

import com.sap.cloud.sdk.odatav2.connectivity.ODataCreateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataDeleteRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataUpdateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.UpdateMethod;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ChangeSetRequestImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ChangeSetUpdateRequest;
/*
 * Represents a builder to create a change set.
 */
public class ChangeSetBuilder {

  private List requests = new ArrayList();

  /**
   * Adds a create request to the change set.
   * @param oDataCreateRequest Represents the create request
   * @return ChangeSetBuilder
   */
  public ChangeSetBuilder addCreateRequest(ODataCreateRequest oDataCreateRequest) {
    this.requests.add(oDataCreateRequest);
    return this;
  }

  /**
   * Adds an update request to the change set.
   * @param oDataUpdateRequest Represents the update request
   * @return ChangeSetBuilder
   */
  public ChangeSetBuilder addUpdateRequest(ODataUpdateRequest oDataUpdateRequest) {
    ChangeSetUpdateRequest request = new ChangeSetUpdateRequest(oDataUpdateRequest, UpdateMethod.PUT);
    this.requests.add(request);
    return this;
  }

  
  /**
   * Adds an update request to the change set.
   * @param oDataUpdateRequest Represents the update request
   * @param UpdateMethod Represents the update method
   * @return ChangeSetBuilder
   */
  public ChangeSetBuilder addUpdateRequest(ODataUpdateRequest oDataUpdateRequest, UpdateMethod method) {
    ChangeSetUpdateRequest request = new ChangeSetUpdateRequest(oDataUpdateRequest, method);
    this.requests.add(request);
    return this;
  }
  
  /**
   * Adds a delete request to the change set.
   * @param oDataDeleteRequest Represents the delete request
   * @return ChangeSetBuilder
   */
  public ChangeSetBuilder addDeleteRequest(ODataDeleteRequest oDataDeleteRequest) {
    this.requests.add(oDataDeleteRequest);
    return this;
  }

  /**
   * Builds a change set from this builder.
   * @return ChangeSet
   */
  public ChangeSet build() {
    return new ChangeSetRequestImpl(this.requests);
  }

  /**
   * Creates a ChangeSetBuilder object.
   * @return ChangeSetBuilder 
   */
  public static ChangeSetBuilder getInstance() {
    return new ChangeSetBuilder();
  }

}
