/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity.cache.metadata;

import java.net.URL;
import java.util.Map;

import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.Edm;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;

public interface MetadataCache {
	
	public abstract Edm getEdm(String URL, HttpClient httpClient, Map<String,String> headers,ErrorResultHandler<?> errorHandler, Boolean cacheMetadata) throws ODataException;
	
	public abstract Edm getEdm(String URL, HttpClient httpClient, Map<String,String> headers,ErrorResultHandler<?> errorHandler, Boolean cacheMetadata, URL metadataFilePath, CacheKey cacheKey, Boolean isCacheRefresh) throws ODataException;
	
	public abstract Edm getEdm(String URL, HttpClient httpClient, Map<String,String> headers,ErrorResultHandler<?> errorHandler, Boolean cacheMetadata, URL metadataFilePath) throws ODataException;
	
	@Deprecated
	public abstract void removeEntry(String completeUrl);
	
	public abstract void removeEntry(CacheKey cacheKey);
	
	public abstract void clearCache();
	
	
}
