package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions.FUNCTIONS;

public class BoolValue implements BaseFilterValue{
	
	private FUNCTIONS operator;	
	private String leftProperty = null;
	private ODataType operand = null;
	
	/**
	 * Constructs BoolValue
	 * @param function name of filter function
	 * @param property name of property or BoolValue as string
	 * @param operand
	 */
	public BoolValue(FUNCTIONS function, ODataProperty property, ODataType<String> operand) {
		this.operand = operand;
		this.operator = function;
		this.leftProperty = property.getField();
	}
	/**
	 * Creates filter expression using its boolvalue as string, eq as operator and false as operand
	 * @return FilterExpression
	 */
	public FilterExpression isFalse() {
		return new FilterExpression(this.toString(), "eq", ODataType.of(false), true);
	}
	/**
	 * Creates filter expression using its boolvalue as string, eq as operator and true as operand
	 * @return FilterExpression
	 */
	public FilterExpression isTrue() {
		return new FilterExpression(this.toString(), "eq", ODataType.of(true), true);
	}
	/**
	 * Returns BoolValue as string
	 */
	@Override
	public String toString(){
		String result = null;
		switch(this.operator) {							
		case ENDSWITH:	
		case STARTSWITH:
			result =  FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.leftProperty, this.operand);
			break;
		case SUBSTRINGOF:
			result =  FilterHelperUtil.buildSubstringOfFunc(this.operator.toString(), this.operand, this.leftProperty.toString());
			break;							
		default:
			break;		
		}
		return result;
	}
	@Override
	public String getStringValue() {		
		return this.toString();
	}

}
