package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions.FUNCTIONS;

public class DateFunction {
	/**
	 * Creates day filter function that returns the day from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing the filter function
	 */
	public static NumValue day(ODataProperty property) {
		return new NumValue(FUNCTIONS.DAY, property, null);
	}
	/**
	 * Creates hour filter function that returns the hour from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing the filter function
	 */
	public static NumValue hour(ODataProperty property) {
		return new NumValue(FUNCTIONS.HOUR, property, null);
	}
	/**
	 * Creates minute filter function that returns the minute from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing the filter function
	 */
	public static NumValue minute(ODataProperty property) {
		return new NumValue(FUNCTIONS.MINUTE, property, null);
	}
	/**
	 * Creates month filter function that returns the month from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing the filter function
	 */
	public static NumValue month(ODataProperty property) {
		return new NumValue(FUNCTIONS.MONTH, property, null);
	}
	/**
	 * Creates second filter function that returns the second from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing the filter function	 
	 */
	public static NumValue second(ODataProperty property) {
		return new NumValue(FUNCTIONS.SECOND, property, null);
	}
	/**
	 * Creates year filter function that returns the year from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing the filter function	 
	 */
	public static NumValue year(ODataProperty property) {
		return new NumValue(FUNCTIONS.YEAR, property, null);
	}
}
