package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.ODataType;

public class FilterHelperUtil {
	
	private FilterHelperUtil() {}
	
	public static String validateParam(String property){
		if(property == null) {
			throw new NullPointerException("Property can not be null");
		}
		else {
			String temp = property.trim();
			if(temp == "") {
				throw new IllegalArgumentException("Property can not be blank");
			}
			else {
				return temp;
			}
		}		
	}
	
	public static String buildUnaryFunc(String operator, String property) {
		StringBuilder sb = new StringBuilder();
		sb.append(operator);
		sb.append("(");
		sb.append(property);
		sb.append(")");
		return sb.toString();
	}
	
	public static String buildBinaryFunc(String operator, String property, ODataType operand) {
		StringBuilder sb = new StringBuilder();
		sb.append(operator);
		sb.append("(");
		sb.append(property);
		sb.append(",");
		sb.append(odataTypeToString(operand));
		sb.append(")");
		return sb.toString();
	}
	
	public static String odataTypeToString(ODataType operand) {
		return operand.getValue() instanceof String ? "'"+operand.getValue().toString()+"'" : operand.getValue().toString();
		
	}
	
	public static String buildTernaryFunc(String operator, String property, ODataType pos, ODataType len) {
		StringBuilder sb = new StringBuilder();
		sb.append(operator);
		sb.append("(");
		sb.append(property);
		sb.append(",");
		sb.append(odataTypeToString(pos));
		sb.append(",");
		sb.append(odataTypeToString(len));
		sb.append(")");
		return sb.toString();
		
	}

	public static String buildSubstringOfFunc(String operator, ODataType value, String property) {
		StringBuilder sb = new StringBuilder();
		sb.append(operator);
		sb.append("('");
		sb.append(value.getValue());
		sb.append("',");
		sb.append(property);
		sb.append(")");
		return sb.toString();
	}

}
