package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions.FUNCTIONS;

public class NumValue implements LogicalOperators, BaseFilterValue {
	private FUNCTIONS operator;
	private String property;
	private ODataType operand;
	
	/**
	 * Constructs NumValue
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string 
	 * @param operand
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public NumValue(FUNCTIONS operator, ODataProperty property, ODataType<String> operand){
		this.operator = operator;
		this.property = FilterHelperUtil.validateParam(property.getField());
		this.operand = operand;
	}
	/**
	 * Creates filter expression using its NumValue as string, eq as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression eq(ODataType right) {
		return new FilterExpression(this.toString(), "eq", right, true);
	}
	/**
	 * Creates filter expression using its NumValue as string, ne as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression ne(ODataType right) {
		return new FilterExpression(this.toString(), "ne", right, true);
	}
	/**
	 * Creates filter expression using its NumValue as string, gt as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression gt(ODataType right) {
		return new FilterExpression(this.toString(), "gt", right, true);
	}
	/**
	 * Creates filter expression using its NumValue as string, ge as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression ge(ODataType right) {
		return new FilterExpression(this.toString(), "ge", right, true);
	}
	/**
	 * Creates filter expression using its NumValue as string, le as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression le(ODataType right) {
		return new FilterExpression(this.toString(), "le", right, true);
	}
	/**
	 * Creates filter expression using its NumValue as string, lt as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression lt(ODataType right) {
		return new FilterExpression(this.toString(), "lt", right, true);
	}
	/**
	 * Returns NumValue as string
	 */
	@Override
	public String toString() {
		String result = null;
		switch(this.operator) {
		case CEILING:	
		case DAY:
		case FLOOR:
		case HOUR:	
		case LENGTH:
		case MINUTE:
		case MONTH:	
		case ROUND:
		case SECOND:	
		case YEAR:
			result = FilterHelperUtil.buildUnaryFunc(this.operator.toString(), this.property);
			break;
		case ADD:
		case SUB:
		case MUL:
		case DIV:
		case MOD:
		case INDEXOF:
			result = FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.property, this.operand);
			break;
		default:
			break;
		
		}
		return result;
		
	}
	@Override
	public String getStringValue() {		
		return this.toString();
	}
}
