package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions.FUNCTIONS;

public class StringValue implements LogicalOperators, BaseFilterValue{
	
	private FUNCTIONS operator;	
	private String leftProperty = null;
	private ODataType operand = null;
	private Integer length = null;
	private Integer position = null;
	private String find = null;
	private String replace = null;
	
	/**
	 * Constructs StringValue 
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string
	 * @param operand 
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public StringValue(FUNCTIONS operator, ODataProperty property, ODataType operand){		
			this.leftProperty =	FilterHelperUtil.validateParam(property.getField());
			this.operator = operator;						
			this.operand = operand;		
	}
	/**
	 * Constructs StringValue 
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string
	 * @param operand 
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public StringValue(FUNCTIONS operator, StringValue property, ODataType operand){		
			this.leftProperty =	FilterHelperUtil.validateParam(property.toString());
			this.operator = operator;						
			this.operand = operand;		
	}
	/**
	 * Constructs StringValue
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string 
	 * @param pos
	 * @param length
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public StringValue(FUNCTIONS operator, ODataProperty property, Integer pos, Integer length){
		this.operator = operator;
		this.leftProperty =	FilterHelperUtil.validateParam(property.getField());
		this.position = pos;
		this.length = length;
	}
	
	/**
	 * Constructs StringValue
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string 
	 * @param pos
	 * @param length
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public StringValue(FUNCTIONS operator, StringValue property, Integer pos, Integer length){
		this.operator = operator;
		this.leftProperty =	FilterHelperUtil.validateParam(property.toString());
		this.position = pos;
		this.length = length;
	}
	/**
	 * Constructs StringValue
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string 
	 * @param find
	 * @param replace
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public StringValue(FUNCTIONS operator, ODataProperty property, String find, String replace){
		this.operator = operator;
		this.leftProperty =	FilterHelperUtil.validateParam(property.getField());
		this.find = find;
		this.replace = replace;
	}
	/**
	 * Constructs StringValue
	 * @param operator name of filter function
	 * @param property name of property or StringValue as string 
	 * @param find
	 * @param replace
	 * @throws NullPointerException
	 * @throws IllegalArgumentException
	 */
	public StringValue(FUNCTIONS operator, StringValue property, String find, String replace){
		this.operator = operator;
		this.leftProperty =	FilterHelperUtil.validateParam(property.toString());
		this.find = find;
		this.replace = replace;
	}
	/**
	 * Creates filter expression using its StringValue as string, eq as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression eq(ODataType right) {
		return new FilterExpression(this.toString(), "eq", right, true);
	}
	/**
	 * Creates filter expression using its StringValue as string, ne as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression ne(ODataType right) {
		return new FilterExpression(this.toString(), "ne", right, true);
	}
	/**
	 * Creates filter expression using its StringValue as string, gt as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression gt(ODataType right) {
		return new FilterExpression(this.toString(), "gt", right, true);
	}
	/**
	 * Creates filter expression using its StringValue as string, ge as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression ge(ODataType right) {
		return new FilterExpression(this.toString(), "ge", right, true);
	}
	/**
	 * Creates filter expression using its StringValue as string, le as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression le(ODataType right) {
		return new FilterExpression(this.toString(), "le", right, true);
	}
	/**
	 * Creates filter expression using its StringValue as string, lt as operator and odatatype value as operand
	 */
	@Override
	public FilterExpression lt(ODataType right) {
		return new FilterExpression(this.toString(), "lt", right, true);
	}
	/**
	 * Returns StringValue as string
	 */
	@Override
	public String toString(){
		String result = null;
		switch(this.operator) {		
		case CONCAT:							
			result =  FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.leftProperty, this.operand);
			break;				
		case SUBSTRING:
			if(this.length != null) {
				result = FilterHelperUtil.buildTernaryFunc(this.operator.toString(), this.leftProperty, ODataType.of(this.position), ODataType.of(this.length));
			}
			else {
				result = FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.leftProperty, ODataType.of(this.position));
			}
			break;	
		case REPLACE:
			result = FilterHelperUtil.buildTernaryFunc(this.operator.toString(), this.leftProperty, ODataType.of(this.find), 
					ODataType.of(this.replace));
			break;
		case TOLOWER:			
		case TOUPPER:			
		case TRIM:
			result = FilterHelperUtil.buildUnaryFunc(this.operator.toString(), this.leftProperty);
			break;		
		default:
			break;
		
		}
		return result;

	}
	@Override
	public String getStringValue() {		
		return this.toString();
	}
}
