/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import static com.sap.cloud.sdk.odatav2.connectivity.ODataGsonBuilder.newGsonBuilder;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;

import com.google.gson.JsonSyntaxException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;

import lombok.NoArgsConstructor;

@NoArgsConstructor
public class ODataExceptionInternalResultHandler implements ErrorResultHandler<ODataException>
{
    private static final Logger logger = CloudLoggerFactory.getLogger(ODataExceptionInternalResultHandler.class);
    public static final String MISSING_ERROR_PARAM = "No error field found in HttpResponse";
    public static final String MISSING_MESSAGE_OR_VALUE_PARAM = "No message or value field found in HttpResponse";

    protected Class<ODataExceptionInternal> getExceptionType() {
		return null;
	}

    @Override
    public ODataExceptionInternal createError( final String message, final Object response, final int httpStatusCode)
    {
        boolean isXml = false;
        final ODataExceptionInternal exception;
        String responseJson = message;
        HttpResponse httpresponse = (HttpResponse)response;
        final String httpStatusLine = httpresponse.getStatusLine().toString();
		final Header[] httpHeaders = httpresponse.getAllHeaders();
            exception = new ODataExceptionInternal();
            try {
            	
               if(httpStatusCode != 0){
            	   exception.setHttpStatusCode(httpStatusCode);
               }
               
               if(!StringUtils.isEmpty(httpStatusLine) && httpStatusLine != null){
            	   exception.setHttpStatusLine(httpStatusLine);
               }
               
               if(httpHeaders != null && httpHeaders.length != 0){
            	   exception.setHttpHeaders(httpHeaders);
               }
			if (!StringUtils.isEmpty(responseJson)) {
				if (responseJson.startsWith("<")) {
					isXml = true;
					JSONObject xmlJSONObj = XML.toJSONObject(responseJson);
					responseJson = xmlJSONObj.toString();
				}
				if (responseJson != null) {
					exception.setHttpErrorResponseBody(responseJson);
				}

				final Map<?, ?> r = newGsonBuilder().create().fromJson(responseJson, Map.class);
				final Object error = r.get("error");
				if (error instanceof Map) {
					final Object code = ((Map<?, ?>) error).get("code");
					final Object msg = ((Map<?, ?>) error).get("message");
					if (msg instanceof Map) {
						final Object messageValue = ((Map<?, ?>) msg).get("value");
						if (messageValue != null) {
							exception.setMessage(messageValue.toString());
						}
					}
					if (StringUtils.isEmpty(exception.getMessage())) {
						exception.setMessage(MISSING_MESSAGE_OR_VALUE_PARAM);
					}
					if (code != null) {
						exception.setCode(code.toString());
					}
				}
			}
          }
           catch( final JsonSyntaxException | JSONException e ) {
        	   logger.info("Error occured in the HttpResponse",e);
           }
           if( exception != null && StringUtils.isEmpty(exception.getMessage()) ) {
               exception.setMessage(MISSING_ERROR_PARAM);
           }
           logger.error("HttpResponse Error : HttpResponseStatusCode " + exception.getHttpStatusLine() + "  HttpResponseBody :" +  exception.getHttpErrorResponseBody());
           return exception;
    }

}
