/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;

public class UrlEncoder
{
    public static String encode(final String toBeEncoded )
    {
        try {
            return URLEncoder.encode(toBeEncoded, "UTF-8").replace("+", "%20");
        }
        catch( final UnsupportedEncodingException e ) {
            throw new ShouldNotHappenException(e);
        }
    }
}
