/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataDeleteRequest;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataDeleteRequestImpl;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ODataDeleteRequestBuilder {
    private String serviceName;
    private String entitySetName;
    private Map<String, Object> keys;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> destinationRelevantHeaders = new HashMap<String, String>();
    private boolean cacheMetadata = false;
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private boolean isCacheRefresh = false;

    private ODataDeleteRequestBuilder(String serviceName, String entitySetName, Map<String, Object> keys) {
        this.serviceName = serviceName;
        this.entitySetName = entitySetName;
        this.keys = keys;
    }

    public ODataDeleteRequestBuilder withErrorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ODataDeleteRequestBuilder enableMetadataCache() {
        this.cacheMetadata = true;
        return this;
    }

    public ODataDeleteRequestBuilder enableMetadataCache(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
        this.cacheMetadata = true;
        return this;
    }

    public ODataDeleteRequestBuilder withCacheRefresh() {
        this.isCacheRefresh = true;
        return this;
    }

    public ODataDeleteRequestBuilder withMetadata(URL metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
        return this;
    }

    public static ODataDeleteRequestBuilder withEntity(String serviceName, String entitySetName, Map<String, Object> keys) {
        return new ODataDeleteRequestBuilder(serviceName, entitySetName, keys);
    }

    public ODataDeleteRequestBuilder withHeader(String key, String value) {
        return this.withHeader(key, value, false);
    }

    public ODataDeleteRequestBuilder withHeader(String key, String value, boolean passInAllRequests) {
        if (passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        if (key.equals("SAP-PASSPORT") && !passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        this.headers.put(key, value);
        return this;
    }

    public ODataDeleteRequest build() {
        return new ODataDeleteRequestImpl(this.serviceName, this.entitySetName, this.keys, this.errorHandler, this.headers, this.destinationRelevantHeaders, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
    }
}

