/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.http.Header;

public class ODataException
extends Exception {
    private static final long serialVersionUID = 1885636855371872127L;
    private ODataExceptionType type;
    String code;
    private String message;
    protected int httpStatusCode;
    protected String httpStatusLine;
    protected transient Header[] httpHeaders;
    protected String httpErrorResponseBody;
    private static ResourceBundle bundle;
    private static final String DEFAULT_BUNDLE_NAME = "odata-exceptions-i18n";

    public ODataException(ODataExceptionType exceptionType, String s, Throwable e) {
        super(s, e);
        if (exceptionType == null) {
            this.type = ODataExceptionType.OTHER;
            this.message = ODataException.getMessage(ODataExceptionType.OTHER.name(), Locale.ENGLISH) + ": " + s;
        } else {
            this.type = exceptionType;
            this.message = ODataException.getMessage(exceptionType.name(), Locale.ENGLISH) + ": " + s;
        }
    }

    public ODataException(ODataExceptionType exceptionType, String s) {
        if (exceptionType == null) {
            this.type = ODataExceptionType.OTHER;
            this.message = ODataException.getMessage(ODataExceptionType.OTHER.name(), Locale.ENGLISH) + ": " + s;
        } else {
            this.type = exceptionType;
            this.message = ODataException.getMessage(exceptionType.name(), Locale.ENGLISH) + ": " + s;
        }
    }

    public ODataException(ODataExceptionType exceptionType, String s, int statusCode, Throwable e) {
        super(s, e);
        if (exceptionType == null) {
            this.type = ODataExceptionType.OTHER;
            this.message = ODataException.getMessage(ODataExceptionType.OTHER.name(), Locale.ENGLISH) + ": " + s;
            this.httpStatusCode = statusCode;
        } else {
            this.type = exceptionType;
            this.message = ODataException.getMessage(exceptionType.name(), Locale.ENGLISH) + ": " + s;
            this.httpStatusCode = statusCode;
        }
    }

    public ODataExceptionType getODataExceptionType() {
        return this.type;
    }

    public ODataException() {
        this.type = ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getHttpStatusLine() {
        return this.httpStatusLine;
    }

    public Header[] getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpErrorResponseBody() {
        return this.httpErrorResponseBody;
    }

    private static String getMessage(String key, Locale locale) {
        try {
            bundle = ResourceBundle.getBundle(DEFAULT_BUNDLE_NAME, locale);
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

