/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataNavigationRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.api.IQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataQueryImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ODataQueryBuilder
implements IQueryBuilder {
    static final Logger logger = LoggerFactory.getLogger(ODataQueryBuilder.class);
    public static final char QUERY_PARAM_SEPARATOR = '&';
    private final String servicePath;
    private final String entity;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> destinationRelevantHeaders = new HashMap<String, String>();
    private List<ODataNavigationRequest> navigationProperties = new ArrayList<ODataNavigationRequest>();
    private ODataNavigationRequest navigationProperty;
    private Number top;
    private Number skip;
    String inlineCount = null;
    private boolean useMetadata = true;
    private final Map<String, Object> queryParams = Maps.newHashMap();
    private final List<String> selects = Lists.newArrayList();
    private final List<FilterExpression> filters = Lists.newArrayList();
    private final List<String> expands = Lists.newArrayList();
    private Map<String, Object> keys;
    private boolean cacheMetadata = false;
    private CacheKey cacheKey;
    private boolean isCacheRefresh = false;
    private URL metadataFilePath;

    private ODataQueryBuilder(String servicePath, String entity) {
        this.servicePath = servicePath;
        this.entity = entity;
    }

    public static ODataQueryBuilder withEntity(String servicePath, String entity) {
        return new ODataQueryBuilder(servicePath, entity);
    }

    @Override
    public ODataQueryBuilder select(String ... selects) {
        Collections.addAll(this.selects, selects);
        return this;
    }

    @Override
    public ODataQueryBuilder select(List<String> selects) {
        String[] s = selects.toArray(new String[selects.size()]);
        Collections.addAll(this.selects, s);
        return this;
    }

    @Override
    public ODataQueryBuilder enableMetadataCache() {
        this.cacheMetadata = true;
        return this;
    }

    @Override
    public ODataQueryBuilder enableMetadataCache(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
        this.cacheMetadata = true;
        return this;
    }

    @Override
    public ODataQueryBuilder withCacheRefresh() {
        this.isCacheRefresh = true;
        return this;
    }

    @Override
    public ODataQueryBuilder withMetadata(URL metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
        return this;
    }

    @Override
    public ODataQueryBuilder withHeader(String key, String value) {
        return this.withHeader(key, value, false);
    }

    @Override
    public ODataQueryBuilder withHeader(String key, String value, boolean passInAllRequests) {
        if (passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        if (key.equals("SAP-PASSPORT") && !passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        this.headers.put(key, value);
        return this;
    }

    @Override
    public ODataQueryBuilder inlineCount() {
        this.inlineCount = "allpages";
        return this;
    }

    @Override
    public ODataQueryBuilder expand(String ... expands) {
        Collections.addAll(this.expands, expands);
        return this;
    }

    @Override
    public ODataQueryBuilder top(Integer n) {
        if (n != null && n >= 0) {
            this.top = n;
        }
        return this;
    }

    @Override
    public ODataQueryBuilder skip(Integer n) {
        if (n != null && n >= 0) {
            this.skip = n;
        }
        return this;
    }

    @Override
    public final ODataQueryBuilder filter(FilterExpression filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public ODataQueryBuilder param(String key, Object value) {
        if (key.equals("$inlinecount") && value.toString().equals("allpages")) {
            this.inlineCount();
        } else {
            this.queryParams.put(key, value);
        }
        return this;
    }

    @Override
    public ODataQueryBuilder withoutMetadata() {
        this.useMetadata = false;
        return this;
    }

    @Override
    public ODataQueryBuilder keys(Map<String, Object> keys) {
        if (this.navigationProperty != null) {
            this.navigationProperty.keys(keys);
        } else {
            this.keys = keys;
        }
        return this;
    }

    @Override
    public ODataQueryBuilder useMetadata(boolean useMetadata) {
        this.useMetadata = useMetadata;
        return this;
    }

    @Override
    public ODataQuery build() {
        if (this.keys != null) {
            this.inlineCount = null;
        }
        if (this.keys != null || !this.filters.isEmpty()) {
            this.useMetadata = true;
        }
        return new ODataQueryImpl(this.servicePath, this.entity, this.keys, new ODataQueryResolver(), this.errorHandler, this.headers, this.destinationRelevantHeaders, this.useMetadata, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh, this.navigationProperties);
    }

    @Override
    public ODataQueryBuilder navigateTo(String navigation) {
        this.navigationProperty = new ODataNavigationRequest(navigation);
        this.navigationProperties.add(this.navigationProperty);
        return this;
    }

    public ODataQueryBuilder errorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public class ODataQueryResolver {
        public String getQuery() {
            try {
                return this.getQuery(null);
            }
            catch (EdmException e) {
                logger.error("Error while forming the query", (Throwable)e);
                return null;
            }
        }

        public String getQuery(EdmEntityType entityType) throws EdmException {
            ArrayList<String> modifiers = new ArrayList<String>();
            this.addModifierFilter(modifiers, ODataQueryBuilder.this.filters, entityType);
            this.addModifier(modifiers, ODataQueryBuilder.this.queryParams);
            this.addModifier(modifiers, "$select", ODataQueryBuilder.this.selects);
            this.addModifier(modifiers, "$expand", ODataQueryBuilder.this.expands);
            this.addModifier(modifiers, "$top", ODataQueryBuilder.this.top);
            this.addModifier(modifiers, "$skip", ODataQueryBuilder.this.skip);
            this.addModifier(modifiers, "$format", "json");
            this.addModifier(modifiers, "$inlinecount", ODataQueryBuilder.this.inlineCount);
            return StringUtils.join(modifiers, (char)'&');
        }

        private void addModifier(ArrayList<String> mods, String label, Object val) {
            if (val != null) {
                mods.add(label + "=" + val.toString());
            }
        }

        private void addModifier(ArrayList<String> mods, String label, Iterable<String> values) {
            StringBuilder valueBlock = new StringBuilder();
            if (values != null && values.iterator().hasNext()) {
                ArrayList encodedItems = Lists.newArrayList();
                for (String val : values) {
                    encodedItems.add(val);
                }
                mods.add(label + "=" + StringUtils.join((Iterable)encodedItems, (char)','));
            }
        }

        private void addModifierFilter(ArrayList<String> mods, List<FilterExpression> values, EdmEntityType entityType) throws EdmException {
            if (values != null) {
                Iterator<FilterExpression> iterator = values.iterator();
                FilterExpression filter = null;
                while (iterator.hasNext()) {
                    filter = filter == null ? iterator.next() : filter.and(iterator.next());
                }
                if (filter != null) {
                    this.addModifier(mods, "$filter", filter.toString(entityType));
                }
            }
        }

        private void addModifier(ArrayList<String> mods, Map<String, Object> properties) {
            if (properties != null) {
                for (Map.Entry<String, Object> property : properties.entrySet()) {
                    this.addModifier(mods, property.getKey(), property.getValue().toString());
                }
            }
        }
    }
}

