/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ODataGsonBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ResultData;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataHttpResponseWrapper;
import com.sap.cloud.sdk.result.CollectedResultCollection;
import com.sap.cloud.sdk.result.DefaultCollectedResultCollection;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.slf4j.Logger;

public class ODataQueryResult
extends ODataHttpResponseWrapper
implements Iterable<ResultElement> {
    private static final Logger logger = CloudLoggerFactory.getLogger(ODataQuery.class);
    private static final String APPLICATION_JSON = "application/json";
    private String streamData;
    private HttpResponse httpResponse;
    private EdmEntitySet entitySet;
    private ResultElement resultElement;
    private boolean hasResultElement = false;
    String contentType = "application/json";
    InputStream istream;
    Integer inlineCount = null;
    boolean inlineCountAlreadyCalculated = false;
    byte[] buffer;
    @JsonIgnore
    private ODataQuery query;

    ODataQueryResult(EdmEntitySet eset, HttpResponse httpResponse, boolean isMediaRequest) throws IllegalStateException, IOException {
        this.httpResponse = httpResponse;
        if (!isMediaRequest) {
            this.streamData = this.inputStreamToString();
        }
        this.entitySet = eset;
        this.setResponse(httpResponse);
    }

    public ODataQueryResult(String streamData, Map<String, List<String>> headerMap, int statusCode, EdmEntitySet eset) {
        this.entitySet = eset;
        this.streamData = streamData;
        this.responseStatusCode = statusCode;
        this.headersMap = headerMap;
    }

    public ODataQueryResult(EdmEntitySet eset, HttpResponse httpResponse) throws IllegalStateException, IOException {
        this(eset, httpResponse, false);
    }

    @Deprecated
    public ODataQueryResult(ResultElement resultElmnt, HttpResponse httpResponse) throws IllegalStateException, IOException {
        this.httpResponse = httpResponse;
        this.streamData = this.inputStreamToString();
        this.resultElement = resultElmnt;
        this.hasResultElement = true;
        this.setResponse(httpResponse);
    }

    private String inputStreamToString() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.buffer = new byte[1024];
        try {
            int length;
            InputStream inputStream = this.httpResponse.getEntity().getContent();
            while ((length = inputStream.read(this.buffer)) != -1) {
                result.write(this.buffer, 0, length);
            }
            return result.toString("UTF-8");
        }
        catch (IOException | IllegalStateException e) {
            logger.error("Failed to convert inputsteam into string" + e.getMessage());
            return null;
        }
    }

    private InputStream stringToInputStream() throws UnsupportedEncodingException {
        ByteArrayInputStream stream = null;
        if (this.streamData != null) {
            stream = new ByteArrayInputStream(this.streamData.getBytes("UTF-8"));
        }
        return stream;
    }

    private ResultElement loadEntriesFromResponse() {
        ResultElement result = null;
        if (this.streamData != null) {
            JsonElement responseElement = new JsonParser().parse(this.streamData);
            JsonObject resultContainer = responseElement.getAsJsonObject().getAsJsonObject("d");
            if (this.inlineCount == null) {
                if (resultContainer.has("__count")) {
                    this.inlineCount = resultContainer.getAsJsonPrimitive("__count").getAsInt();
                }
                this.inlineCountAlreadyCalculated = true;
            }
            GsonResultElementFactory resultElementFactory = new GsonResultElementFactory(ODataGsonBuilder.newGsonBuilder());
            result = resultContainer.has("results") ? resultElementFactory.create((JsonElement)resultContainer.getAsJsonArray("results")) : resultElementFactory.create((JsonElement)resultContainer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultData> asListOfResultData() {
        InputStream inputStream;
        LinkedList<ResultData> result;
        block10: {
            LinkedList<ResultData> linkedList;
            result = new LinkedList<ResultData>();
            JsonElement jsonElement = null;
            String etag = null;
            inputStream = null;
            try {
                JsonElement metadata;
                inputStream = this.buffer == null ? this.stringToInputStream() : new ByteArrayInputStream(this.buffer);
                if (inputStream == null) break block10;
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                reader.beginObject();
                reader.nextName();
                Gson gson = ODataGsonBuilder.newGsonBuilder().create();
                if (this.streamData.contains("results")) {
                    reader.beginObject();
                    if (reader.nextName().equals("results")) {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            JsonElement etagData;
                            jsonElement = (JsonElement)gson.fromJson(reader, JsonElement.class);
                            metadata = jsonElement.getAsJsonObject().get("__metadata");
                            if (metadata != null && (etagData = metadata.getAsJsonObject().get("etag")) != null) {
                                etag = etagData.getAsString();
                            }
                            ODataEntry entry = EntityProvider.readEntry((String)APPLICATION_JSON, (EdmEntitySet)this.entitySet, (InputStream)new ByteArrayInputStream(jsonElement.toString().getBytes("UTF-8")), (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                            ResultData finalResult = new ResultData();
                            Map<String, Object> data = this.getFlattenMapData(entry);
                            finalResult.setData(data);
                            finalResult.setEtag(etag);
                            result.add(finalResult);
                        }
                    }
                } else {
                    JsonElement etagData;
                    jsonElement = (JsonElement)gson.fromJson(reader, JsonElement.class);
                    metadata = jsonElement.getAsJsonObject().get("__metadata");
                    if (metadata != null && (etagData = metadata.getAsJsonObject().get("etag")) != null) {
                        etag = etagData.getAsString();
                    }
                    ODataEntry entry = EntityProvider.readEntry((String)APPLICATION_JSON, (EdmEntitySet)this.entitySet, (InputStream)new ByteArrayInputStream(jsonElement.toString().getBytes("UTF-8")), (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                    ResultData finalResult = new ResultData();
                    Map<String, Object> data = this.getFlattenMapData(entry);
                    finalResult.setData(data);
                    finalResult.setEtag(etag);
                    result.add(finalResult);
                }
                linkedList = result;
            }
            catch (IOException | UnsupportedOperationException | EntityProviderException e) {
                try {
                    logger.error("Failed in asListOfMapWithEtag method" + e.getMessage(), e);
                    this.closeInputStream(inputStream);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(inputStream);
                    throw throwable;
                }
            }
            this.closeInputStream(inputStream);
            return linkedList;
        }
        this.closeInputStream(inputStream);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> asMap() {
        Map<String, Object> jsonMap = null;
        InputStream instream = null;
        try {
            if (!this.hasResultElement) {
                instream = this.stringToInputStream();
                if (instream != null) {
                    ODataEntry entry = EntityProvider.readEntry((String)APPLICATION_JSON, (EdmEntitySet)this.entitySet, (InputStream)instream, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                    jsonMap = this.getFlattenMapData(entry);
                }
            } else {
                logger.info("asMap API will not work as deprecated ODataQueryResult constructor is used");
            }
            this.closeInputStream(instream);
        }
        catch (UnsupportedEncodingException | EntityProviderException e) {
            try {
                logger.error("Failed to convert response into ODataFeed: " + e.getMessage());
                this.closeInputStream(instream);
            }
            catch (Throwable throwable) {
                this.closeInputStream(instream);
                throw throwable;
            }
        }
        return jsonMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> asListOfMaps() {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        InputStream instream = null;
        try {
            if (!this.hasResultElement) {
                instream = this.stringToInputStream();
                if (instream != null) {
                    ODataFeed feed = EntityProvider.readFeed((String)APPLICATION_JSON, (EdmEntitySet)this.entitySet, (InputStream)instream, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                    List entries = feed.getEntries();
                    this.inlineCount = feed.getFeedMetadata().getInlineCount();
                    this.inlineCountAlreadyCalculated = true;
                    for (ODataEntry entry : entries) {
                        Map<String, Object> finalResult = this.getFlattenMapData(entry);
                        result.add(finalResult);
                    }
                }
            } else {
                logger.info("asListOfMaps API will not work as deprecated ODataQueryResult constructor is used");
            }
            this.closeInputStream(instream);
        }
        catch (UnsupportedEncodingException | EntityProviderException e) {
            try {
                logger.error("Failed to convert response into ODataFeed: " + e.getMessage());
                this.closeInputStream(instream);
            }
            catch (Throwable throwable) {
                this.closeInputStream(instream);
                throw throwable;
            }
        }
        return result;
    }

    private void closeInputStream(InputStream instream) {
        try {
            if (instream != null) {
                instream.close();
            }
        }
        catch (IOException e) {
            logger.warn("Unable to safely close the inputstream" + e.getMessage());
        }
    }

    private Map<String, Object> getFlattenMapData(ODataEntry entry) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        for (Map.Entry property : entry.getProperties().entrySet()) {
            if (property.getValue() instanceof ODataFeed) {
                ODataFeed feedExpand = (ODataFeed)property.getValue();
                ArrayList<Map<String, Object>> allChildren = new ArrayList<Map<String, Object>>();
                for (ODataEntry feedEntry : feedExpand.getEntries()) {
                    allChildren.add(this.getFlattenMapData(feedEntry));
                }
                finalResult.put((String)property.getKey(), allChildren);
                continue;
            }
            if (property.getValue() instanceof ODataEntry) {
                ODataEntry entryFeed = (ODataEntry)property.getValue();
                finalResult.put((String)property.getKey(), this.getFlattenMapData(entryFeed));
                continue;
            }
            finalResult.put((String)property.getKey(), property.getValue());
        }
        return finalResult;
    }

    public <T> List<T> asList(Class<T> objectType) throws IllegalArgumentException {
        ArrayList result = Lists.newArrayList();
        for (ResultElement element : this.getResultElements()) {
            if (!element.isResultObject()) continue;
            result.add(element.getAsObject().as(objectType));
        }
        return result;
    }

    public <T> T as(Class<T> objectType) {
        ResultElement resultElnt = null;
        try {
            resultElnt = this.hasResultElement ? this.resultElement : this.loadEntriesFromResponse();
            if (resultElnt != null && resultElnt.isResultObject()) {
                return (T)resultElnt.getAsObject().as(objectType);
            }
        }
        catch (IllegalStateException e) {
            logger.debug("Failed to convert httpresponse into ResultElement : " + e.getMessage());
        }
        return null;
    }

    public Iterable<ResultElement> getResultElements() {
        ArrayList returnList = Lists.newArrayList();
        ResultElement resultElnt = null;
        try {
            resultElnt = this.hasResultElement ? this.resultElement : this.loadEntriesFromResponse();
            if (resultElnt != null && resultElnt.isResultCollection()) {
                for (ResultElement recentResultElement : resultElnt.getAsCollection()) {
                    returnList.add(recentResultElement);
                }
            }
        }
        catch (IllegalStateException e) {
            logger.debug("Failed to convert httpresponse into ResultElement : " + e.getMessage());
        }
        return returnList;
    }

    public CollectedResultCollection collect(String elementName) {
        return new DefaultCollectedResultCollection(elementName, this.getResultElements());
    }

    public Optional<ResultElement> getIfPresent(String elementName) throws IllegalArgumentException {
        Optional<ResultElement> resultElement = this.getResultElement(elementName);
        if (!resultElement.isPresent()) {
            return Optional.absent();
        }
        return resultElement;
    }

    @Override
    public Iterator<ResultElement> iterator() {
        return this.getResultElements().iterator();
    }

    public Integer getInlineCount() {
        if (this.inlineCountAlreadyCalculated) {
            return this.inlineCount;
        }
        return this.extractInlineCountFromResponseString();
    }

    private Integer extractInlineCountFromResponseString() {
        Matcher m;
        String inlineCountRegex = "__count\":\\s*\"(\\d+)\"";
        Pattern icpattern = Pattern.compile(inlineCountRegex);
        if (this.streamData != null && (m = icpattern.matcher(this.streamData)).find()) {
            return Integer.parseInt(m.group(1));
        }
        return null;
    }

    public Optional<ResultElement> getResultElement(String elementName) throws IllegalArgumentException {
        try {
            ResultElement resultElement = this.loadEntriesFromResponse();
            if (resultElement != null && resultElement.isResultObject()) {
                return Optional.fromNullable((Object)resultElement.getAsObject().get(elementName));
            }
        }
        catch (IllegalStateException e) {
            logger.debug("Failed to convert httpresponse into ResultElement : " + e.getMessage());
        }
        return Optional.absent();
    }

    public String getStreamData() {
        return this.streamData;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public EdmEntitySet getEntitySet() {
        return this.entitySet;
    }

    public ResultElement getResultElement() {
        return this.resultElement;
    }

    public boolean isHasResultElement() {
        return this.hasResultElement;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getIstream() {
        return this.istream;
    }

    public boolean isInlineCountAlreadyCalculated() {
        return this.inlineCountAlreadyCalculated;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setStreamData(String streamData) {
        this.streamData = streamData;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setEntitySet(EdmEntitySet entitySet) {
        this.entitySet = entitySet;
    }

    public void setResultElement(ResultElement resultElement) {
        this.resultElement = resultElement;
    }

    public void setHasResultElement(boolean hasResultElement) {
        this.hasResultElement = hasResultElement;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setIstream(InputStream istream) {
        this.istream = istream;
    }

    public void setInlineCount(Integer inlineCount) {
        this.inlineCount = inlineCount;
    }

    public void setInlineCountAlreadyCalculated(boolean inlineCountAlreadyCalculated) {
        this.inlineCountAlreadyCalculated = inlineCountAlreadyCalculated;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataQueryResult)) {
            return false;
        }
        ODataQueryResult other = (ODataQueryResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$streamData = this.getStreamData();
        String other$streamData = other.getStreamData();
        if (this$streamData == null ? other$streamData != null : !this$streamData.equals(other$streamData)) {
            return false;
        }
        HttpResponse this$httpResponse = this.getHttpResponse();
        HttpResponse other$httpResponse = other.getHttpResponse();
        if (this$httpResponse == null ? other$httpResponse != null : !this$httpResponse.equals(other$httpResponse)) {
            return false;
        }
        EdmEntitySet this$entitySet = this.getEntitySet();
        EdmEntitySet other$entitySet = other.getEntitySet();
        if (this$entitySet == null ? other$entitySet != null : !this$entitySet.equals(other$entitySet)) {
            return false;
        }
        ResultElement this$resultElement = this.getResultElement();
        ResultElement other$resultElement = other.getResultElement();
        if (this$resultElement == null ? other$resultElement != null : !this$resultElement.equals(other$resultElement)) {
            return false;
        }
        if (this.isHasResultElement() != other.isHasResultElement()) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        InputStream this$istream = this.getIstream();
        InputStream other$istream = other.getIstream();
        if (this$istream == null ? other$istream != null : !this$istream.equals(other$istream)) {
            return false;
        }
        Integer this$inlineCount = this.getInlineCount();
        Integer other$inlineCount = other.getInlineCount();
        if (this$inlineCount == null ? other$inlineCount != null : !((Object)this$inlineCount).equals(other$inlineCount)) {
            return false;
        }
        if (this.isInlineCountAlreadyCalculated() != other.isInlineCountAlreadyCalculated()) {
            return false;
        }
        if (!Arrays.equals(this.getBuffer(), other.getBuffer())) {
            return false;
        }
        ODataQuery this$query = this.getQuery();
        ODataQuery other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODataQueryResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streamData = this.getStreamData();
        result = result * 59 + ($streamData == null ? 43 : $streamData.hashCode());
        HttpResponse $httpResponse = this.getHttpResponse();
        result = result * 59 + ($httpResponse == null ? 43 : $httpResponse.hashCode());
        EdmEntitySet $entitySet = this.getEntitySet();
        result = result * 59 + ($entitySet == null ? 43 : $entitySet.hashCode());
        ResultElement $resultElement = this.getResultElement();
        result = result * 59 + ($resultElement == null ? 43 : $resultElement.hashCode());
        result = result * 59 + (this.isHasResultElement() ? 79 : 97);
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        InputStream $istream = this.getIstream();
        result = result * 59 + ($istream == null ? 43 : $istream.hashCode());
        Integer $inlineCount = this.getInlineCount();
        result = result * 59 + ($inlineCount == null ? 43 : ((Object)$inlineCount).hashCode());
        result = result * 59 + (this.isInlineCountAlreadyCalculated() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getBuffer());
        ODataQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "ODataQueryResult(streamData=" + this.getStreamData() + ", httpResponse=" + this.getHttpResponse() + ", entitySet=" + this.getEntitySet() + ", resultElement=" + this.getResultElement() + ", hasResultElement=" + this.isHasResultElement() + ", contentType=" + this.getContentType() + ", istream=" + this.getIstream() + ", inlineCount=" + this.getInlineCount() + ", inlineCountAlreadyCalculated=" + this.isInlineCountAlreadyCalculated() + ", buffer=" + Arrays.toString(this.getBuffer()) + ", query=" + this.getQuery() + ")";
    }

    public ODataQuery getQuery() {
        return this.query;
    }

    public void setQuery(ODataQuery query) {
        this.query = query;
    }
}

