/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.BaseFilterValue;
import com.sap.cloud.sdk.odatav2.connectivity.filter.DateFunction;
import com.sap.cloud.sdk.odatav2.connectivity.filter.MathFunction;
import com.sap.cloud.sdk.odatav2.connectivity.filter.NumValue;
import com.sap.cloud.sdk.odatav2.connectivity.filter.StringFunction;

public class FilterConverterHelper {
    public static boolean isDateFunction(String functionName) {
        return functionName.equals("DAY") || functionName.equals("HOUR") || functionName.equals("MONTH") || functionName.equals("YEAR") || functionName.equals("SECOND") || functionName.equals("MINUTE");
    }

    public static boolean isMathFunction(String functionName) {
        return functionName.equals("ROUND") || functionName.equals("FLOOR") || functionName.equals("CEILING") || functionName.equals("ADD") || functionName.equals("MUL") || functionName.equals("DIV") || functionName.equals("SUB") || functionName.equals("MOD");
    }

    public static boolean isStringFunction(String functionName) {
        return functionName.equals("CONCAT") || functionName.equals("TRIM") || functionName.equals("REPLACE") || functionName.equals("TOLOWER") || functionName.equals("TOUPPER") || functionName.equals("SUBSTRING") || functionName.equals("ENDSWITH") || functionName.equals("STARTSWITH") || functionName.equals("SUBSTRINGOF") || functionName.equals("INDEXOF") || functionName.equals("LENGTH");
    }

    public static BaseFilterValue createV2StringFunction(String functionName, String property, Object op1, Object op2, int size) {
        BaseFilterValue result = null;
        switch (functionName) {
            case "CONCAT": {
                result = StringFunction.concat(new ODataProperty(property), op1.toString());
                break;
            }
            case "TOLOWER": {
                result = StringFunction.toLower(new ODataProperty(property));
                break;
            }
            case "TOUPPER": {
                result = StringFunction.toUpper(new ODataProperty(property));
                break;
            }
            case "TRIM": {
                result = StringFunction.trim(new ODataProperty(property));
                break;
            }
            case "SUBSTRING": {
                if (size == 3) {
                    result = StringFunction.substring(new ODataProperty(property), Integer.parseInt(op1.toString()), Integer.parseInt(op2.toString()));
                    break;
                }
                if (size != 2) break;
                result = StringFunction.substring(new ODataProperty(property), Integer.parseInt(op1.toString()));
                break;
            }
            case "REPLACE": {
                result = StringFunction.replace(new ODataProperty(property), op1.toString(), op2.toString());
                break;
            }
            case "ENDSWITH": {
                result = StringFunction.endsWith(new ODataProperty(property), op1.toString());
                break;
            }
            case "STARTSWITH": {
                result = StringFunction.startsWith(new ODataProperty(property), op1.toString());
                break;
            }
            case "SUBSTRINGOF": {
                result = StringFunction.isSubstringOf(new ODataProperty(property), op1.toString());
                break;
            }
            case "INDEXOF": {
                result = StringFunction.indexOf(new ODataProperty(property), op1.toString());
                break;
            }
            case "LENGTH": {
                result = StringFunction.length(new ODataProperty(property));
                break;
            }
        }
        return result;
    }

    public static FilterExpression createV2StringFunctionExpression(String functionName, String property, Object op1, Object op2, int size) {
        FilterExpression result = null;
        switch (functionName) {
            case "ENDSWITH": {
                result = new FilterExpression(property, functionName.toLowerCase(), ODataType.of(op1));
                break;
            }
            case "STARTSWITH": {
                result = new FilterExpression(property, functionName.toLowerCase(), ODataType.of(op1));
                break;
            }
            case "SUBSTRINGOF": {
                result = new FilterExpression(property, functionName.toLowerCase(), ODataType.of(op1));
                break;
            }
        }
        return result;
    }

    public static BaseFilterValue createV2MathFunction(String functionName, String property, Object op1) {
        NumValue result = null;
        switch (functionName) {
            case "ROUND": {
                result = MathFunction.round(new ODataProperty(property));
                break;
            }
            case "FLOOR": {
                result = MathFunction.floor(new ODataProperty(property));
                break;
            }
            case "CEILING": {
                result = MathFunction.ceiling(new ODataProperty(property));
                break;
            }
            case "ADD": {
                result = MathFunction.add(new ODataProperty(property), ODataType.of(op1));
                break;
            }
            case "SUB": {
                result = MathFunction.sub(new ODataProperty(property), ODataType.of(op1));
                break;
            }
            case "MUL": {
                result = MathFunction.mul(new ODataProperty(property), ODataType.of(op1));
                break;
            }
            case "DIV": {
                result = MathFunction.div(new ODataProperty(property), ODataType.of(op1));
                break;
            }
            case "MOD": {
                result = MathFunction.mod(new ODataProperty(property), ODataType.of(op1));
                break;
            }
        }
        return result;
    }

    public static BaseFilterValue createV2DateFunction(String functionName, String property, Object op1) {
        NumValue result = null;
        switch (functionName) {
            case "DAY": {
                result = DateFunction.day(new ODataProperty(property));
                break;
            }
            case "MONTH": {
                result = DateFunction.month(new ODataProperty(property));
                break;
            }
            case "YEAR": {
                result = DateFunction.year(new ODataProperty(property));
                break;
            }
            case "HOUR": {
                result = DateFunction.hour(new ODataProperty(property));
                break;
            }
            case "MINUTE": {
                result = DateFunction.minute(new ODataProperty(property));
                break;
            }
            case "SECOND": {
                result = DateFunction.second(new ODataProperty(property));
                break;
            }
        }
        return result;
    }
}

