/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.BaseFilterValue;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterHelperUtil;
import com.sap.cloud.sdk.odatav2.connectivity.filter.LogicalOperators;

public class NumValue
implements LogicalOperators,
BaseFilterValue {
    private FilterFunctions.FUNCTIONS operator;
    private String property;
    private ODataType operand;

    public NumValue(FilterFunctions.FUNCTIONS operator, ODataProperty property, ODataType<String> operand) {
        this.operator = operator;
        this.property = FilterHelperUtil.validateParam(property.getField());
        this.operand = operand;
    }

    @Override
    public FilterExpression eq(ODataType right) {
        return new FilterExpression(this.toString(), "eq", right, true);
    }

    @Override
    public FilterExpression ne(ODataType right) {
        return new FilterExpression(this.toString(), "ne", right, true);
    }

    @Override
    public FilterExpression gt(ODataType right) {
        return new FilterExpression(this.toString(), "gt", right, true);
    }

    @Override
    public FilterExpression ge(ODataType right) {
        return new FilterExpression(this.toString(), "ge", right, true);
    }

    @Override
    public FilterExpression le(ODataType right) {
        return new FilterExpression(this.toString(), "le", right, true);
    }

    @Override
    public FilterExpression lt(ODataType right) {
        return new FilterExpression(this.toString(), "lt", right, true);
    }

    public String toString() {
        String result = null;
        switch (this.operator) {
            case CEILING: 
            case DAY: 
            case FLOOR: 
            case HOUR: 
            case LENGTH: 
            case MINUTE: 
            case MONTH: 
            case ROUND: 
            case SECOND: 
            case YEAR: {
                result = FilterHelperUtil.buildUnaryFunc(this.operator.toString(), this.property);
                break;
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case INDEXOF: {
                result = FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.property, this.operand);
                break;
            }
        }
        return result;
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }
}

