/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.impl;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataDeleteRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataDeleteResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.GuavaMetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.MetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.internal.EdmWithCSRF;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataDeleteRequestImpl
implements ODataDeleteRequest {
    private static Logger logger = LoggerFactory.getLogger(ODataDeleteRequestImpl.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static MetadataCache metadataCache = new GuavaMetadataCache();
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String CONTENTTYPE_ATOM_XML = "application/xml";
    private String serviceName;
    private String entitySetName;
    private Map<String, Object> keys;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers;
    private Map<String, String> destinationRelevantHeaders;
    private Boolean cacheMetadata;
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private Boolean isCacheRefresh;

    public ODataDeleteRequestImpl(String serviceName, String entitySetName, Map<String, Object> keys, ErrorResultHandler<?> errorHandler, Map<String, String> headers, Map<String, String> destinationRelevantHeaders, boolean metadataCache2, URL metadataFilePath, CacheKey cacheKey, boolean isCacheRefresh) {
        this.serviceName = serviceName;
        this.entitySetName = entitySetName;
        this.keys = keys;
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.cacheMetadata = metadataCache2;
        this.metadataFilePath = metadataFilePath;
        this.cacheKey = cacheKey;
        this.isCacheRefresh = isCacheRefresh;
    }

    @Override
    public ODataDeleteResult execute(String destinationName) throws ODataException {
        logger.debug("Delete Called with Destination Name: " + destinationName);
        return this.handleExecute(destinationName, null);
    }

    private ODataDeleteResult handleExecute(String destinationName, HttpClient httpClient) throws ODataException {
        ODataDeleteResult result = null;
        HttpClient httpClient2 = httpClient = destinationName == null ? httpClient : this.getHttpClient(destinationName);
        if (this.cacheMetadata.booleanValue()) {
            try {
                result = this.delete(httpClient);
            }
            catch (ODataException e) {
                if (e.getODataExceptionType().equals((Object)ODataExceptionType.OTHER) || e.getODataExceptionType().equals((Object)ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED)) {
                    throw e;
                }
                this.isCacheRefresh = true;
                result = this.delete(httpClient);
            }
        } else {
            result = this.delete(httpClient);
        }
        return result;
    }

    ODataDeleteResult delete(HttpClient httpClient) throws ODataException {
        String serviceUri = this.serviceName;
        String entitySetName = this.entitySetName;
        String completeUrl = null;
        HttpResponse httpResponse = null;
        Edm edm = null;
        EdmWithCSRF edmWithCSRF = null;
        try {
            edmWithCSRF = ODataConnectivityUtil.readMetadataWithCSRF(serviceUri, httpClient, this.destinationRelevantHeaders, this.errorHandler, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        }
        catch (IOException e) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", null);
        }
        if (edmWithCSRF == null || edmWithCSRF.getEdm() == null) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", null);
        }
        edm = edmWithCSRF.getEdm();
        EdmEntitySet entitySet = null;
        EdmEntityType entityType = null;
        String keyPredicateString = null;
        try {
            entitySet = edm.getDefaultEntityContainer().getEntitySet(entitySetName);
            if (entitySet == null) {
                throw new ODataException(ODataExceptionType.INVALID_ENTITY_NAME, "No entity with name " + entitySetName + " in the OData service", null);
            }
            entityType = entitySet.getEntityType();
            keyPredicateString = ODataConnectivityUtil.convertKeyValuesToString(this.keys, entityType);
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
        completeUrl = serviceUri + "/" + entitySetName + '(' + keyPredicateString + ')';
        HttpDelete requestDelete = new HttpDelete(completeUrl);
        requestDelete.setHeader("x-csrf-token", edmWithCSRF.getCsrfToken());
        requestDelete.setHeader(CONTENT_TYPE, APPLICATION_JSON);
        requestDelete.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            requestDelete.setHeader(header.getKey(), header.getValue());
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)requestDelete);
            ODataConnectivityUtil.checkHttpStatus(httpResponse, this.errorHandler);
        }
        catch (IOException e) {
            throw new ODataException(null, e.getMessage(), e);
        }
        finally {
            ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)requestDelete);
        }
        return new ODataDeleteResult(httpResponse);
    }

    protected HttpClient getHttpClient(String destinationName) {
        Destination dest = (Destination)DestinationAccessor.tryGetDestination((String)destinationName).get();
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)dest.asHttp());
    }

    @Override
    public ODataDeleteResult execute(WithDestinationName withDestinationName) throws ODataException {
        return this.execute(withDestinationName.getDestinationName());
    }

    @Override
    public ODataDeleteResult execute(HttpClient providedClient) throws ODataException {
        logger.debug("Delete Called with Direct URL");
        return this.handleExecute(null, providedClient);
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getEntitySetName() {
        return this.entitySetName;
    }

    Map<String, Object> getKeys() {
        return this.keys;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "DELETE " + ODataConnectivityUtil.withSeparator("/", this.serviceName, this.entitySetName) + " with key " + this.keys.toString();
    }
}

