/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonSyntaxException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataGsonBuilder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class DefaultErrorResultHandler<T extends ODataException>
implements ErrorResultHandler<T> {
    private static final Logger logger = CloudLoggerFactory.getLogger(DefaultErrorResultHandler.class);
    private static final ObjectMapper om = new ObjectMapper();
    public static final String MISSING_ERROR_PARAM = "No error field found in JSON";
    public static final String MISSING_MESSAGE_OR_VALUE_PARAM = "No message or value field found in JSON";

    protected abstract Class<T> getExceptionType();

    private T build(String json, Object origin, int httpStatusCode) {
        ODataException exception;
        Class<T> exceptionType = this.getExceptionType();
        try {
            exception = (ODataException)exceptionType.newInstance();
            Map r = (Map)ODataGsonBuilder.newGsonBuilder().create().fromJson(json, Map.class);
            Object error = r.get("error");
            if (error instanceof Map) {
                Object messageValue;
                Object code = ((Map)error).get("code");
                Object message = ((Map)error).get("message");
                if (message instanceof Map && (messageValue = ((Map)message).get("value")) != null) {
                    exception.setMessage(messageValue.toString());
                }
                if (StringUtils.isEmpty((CharSequence)exception.getMessage())) {
                    exception.setMessage(MISSING_MESSAGE_OR_VALUE_PARAM);
                }
                if (code != null) {
                    exception.setCode(code.toString());
                }
            }
        }
        catch (JsonSyntaxException | IllegalAccessException | InstantiationException e) {
            try {
                exception = (ODataException)exceptionType.newInstance();
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to instantiate " + ODataException.class.getSimpleName() + " object for detailed error message.", e);
                }
            }
            catch (Exception e1) {
                exception = null;
                logger.warn("Failed to instantiate " + exceptionType.getSimpleName() + " with no arguments.", (Throwable)e1);
            }
        }
        if (exception != null && StringUtils.isEmpty((CharSequence)exception.getMessage())) {
            exception.setMessage(MISSING_ERROR_PARAM);
        }
        return (T)exception;
    }

    @Override
    public T createError(String message, Object origin, int httpStatusCode) {
        return this.build(message, origin, httpStatusCode);
    }

    public static DefaultErrorResultHandler<ODataException> create() {
        return new DefaultErrorResultHandler<ODataException>(){

            @Override
            protected Class<ODataException> getExceptionType() {
                return ODataException.class;
            }
        };
    }
}

