/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import com.google.gson.JsonSyntaxException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataGsonBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataExceptionInternal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;

public class ODataExceptionInternalResultHandler
implements ErrorResultHandler<ODataException> {
    private static final Logger logger = CloudLoggerFactory.getLogger(ODataExceptionInternalResultHandler.class);
    public static final String MISSING_ERROR_PARAM = "No error field found in HttpResponse";
    public static final String MISSING_MESSAGE_OR_VALUE_PARAM = "No message or value field found in HttpResponse";

    protected Class<ODataExceptionInternal> getExceptionType() {
        return null;
    }

    @Override
    public ODataExceptionInternal createError(String message, Object response, int httpStatusCode) {
        boolean isXml = false;
        String responseJson = message;
        HttpResponse httpresponse = (HttpResponse)response;
        String httpStatusLine = httpresponse.getStatusLine().toString();
        Header[] httpHeaders = httpresponse.getAllHeaders();
        ODataExceptionInternal exception = new ODataExceptionInternal();
        try {
            if (httpStatusCode != 0) {
                exception.setHttpStatusCode(httpStatusCode);
            }
            if (!StringUtils.isEmpty((CharSequence)httpStatusLine) && httpStatusLine != null) {
                exception.setHttpStatusLine(httpStatusLine);
            }
            if (httpHeaders != null && httpHeaders.length != 0) {
                exception.setHttpHeaders(httpHeaders);
            }
            if (!StringUtils.isEmpty((CharSequence)responseJson)) {
                Map r;
                Object error;
                if (responseJson.startsWith("<")) {
                    isXml = true;
                    JSONObject xmlJSONObj = XML.toJSONObject((String)responseJson);
                    responseJson = xmlJSONObj.toString();
                }
                if (responseJson != null) {
                    exception.setHttpErrorResponseBody(responseJson);
                }
                if ((error = (r = (Map)ODataGsonBuilder.newGsonBuilder().create().fromJson(responseJson, Map.class)).get("error")) instanceof Map) {
                    Object messageValue;
                    Object code = ((Map)error).get("code");
                    Object msg = ((Map)error).get("message");
                    if (msg instanceof Map && (messageValue = ((Map)msg).get("value")) != null) {
                        exception.setMessage(messageValue.toString());
                    }
                    if (StringUtils.isEmpty((CharSequence)exception.getMessage())) {
                        exception.setMessage(MISSING_MESSAGE_OR_VALUE_PARAM);
                    }
                    if (code != null) {
                        exception.setCode(code.toString());
                    }
                }
            }
        }
        catch (JsonSyntaxException | JSONException e) {
            logger.info("Error occured in the HttpResponse", e);
        }
        if (exception != null && StringUtils.isEmpty((CharSequence)exception.getMessage())) {
            exception.setMessage(MISSING_ERROR_PARAM);
        }
        logger.error("HttpResponse Error : HttpResponseStatusCode " + exception.getHttpStatusLine() + "  HttpResponseBody :" + exception.getHttpErrorResponseBody());
        return exception;
    }
}

