/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import lombok.Getter;

public class ODataProperty<T extends ODataType<?>>
{
    @Getter
    private final String field;

    public ODataProperty( final String name )
    {
        field = name;
    }

    public static <T extends ODataType<?>> ODataProperty<T> field( final String name )
    {
        return new ODataProperty<>(name);
    }

    @SuppressWarnings( "unchecked" )
    private static <T extends ODataType<?>> T asODataType( final ODataProperty<T> prop )
    {
        return (T) ODataType.of(prop);
    }

    /**
     * Creates a filter expression by applying eq operator to this OData property with the supplied operand.
     * @param rightOperand ODataType created from the operand.
     * @return FilterExpression
     */
    public FilterExpression eq( final T rightOperand )
    {
        return new FilterExpression(field, "eq", rightOperand);
    }

    /**
     * Creates a filter expression by applying ne operator to this OData property with the supplied operand.
     * @param rightOperand ODataType created from the operand.
     * @return FilterExpression
     */
    public FilterExpression ne( final T rightOperand )
    {
        return new FilterExpression(field, "ne", rightOperand);
    }

    /**
     * Creates a filter expression by applying lt operator to this OData property with the supplied operand.
     * @param rightOperand ODataType created from the operand.
     * @return FilterExpression
     */
    public FilterExpression lt( final T rightOperand )
    {
        return new FilterExpression(field, "lt", rightOperand);
    }

    /**
     * Creates a filter expression by applying le operator to this OData property with the supplied operand.
     * @param rightOperand ODataType created from the operand.
     * @return FilterExpression
     */
    public FilterExpression le( final T rightOperand )
    {
        return new FilterExpression(field, "le", rightOperand);
    }

    /**
     * Creates a filter expression by applying gt operator to this OData property with the supplied operand.
     * @param rightOperand ODataType created from the operand.
     * @return FilterExpression
     */
    public FilterExpression gt( final T rightOperand )
    {
        return new FilterExpression(field, "gt", rightOperand);
    }

    /**
     * Creates a filter expression by applying ge operator to this OData property with the supplied operand.
     * @param rightOperand ODataType created from the operand.
     * @return FilterExpression
     */
    public FilterExpression ge( final T rightOperand )
    {
        return new FilterExpression(field, "ge", rightOperand);
    }
}
