/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import org.apache.http.client.HttpClient;

import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;

public class ODataReadMediaRequest {
	private ODataQuery query;
	
	ODataReadMediaRequest(ODataQuery query){
		this.query = query;
	}
	/**
	 * Executes the query for retrieving the media resource
	 * @param withDestinationName Contains the connection details to the data source
	 * @return ODataMediaResult Represents the media resource retrieved from the data source
	 * @throws ODataException
	 */
	public ODataMediaResult execute(final WithDestinationName withDestinationName) throws ODataException {
		return new ODataMediaResult(this.query.execute(withDestinationName.getDestinationName(), true));
	}

	/**
	 * Executes the query for retrieving the media resource
	 * @param destinationName Destination name representing the data source connection
	 * @return ODataMediaResult Represents the media resource retrieved from the data source
	 * @throws ODataException
	 */
	public ODataMediaResult execute(final String destinationName) throws ODataException {
		return new ODataMediaResult(this.query.execute(destinationName, true));
	}
	
	/**
	 * Executes the query for retrieving the media resource
	 * @param providedHttpClient custom HttpClient capable of connecting to data source connection
	 * @return ODataMediaResult Represents the media resource retrieved from the data source
	 * @throws ODataException
	 */
	public ODataMediaResult execute(HttpClient providedHttpClient) throws ODataException {
		return new ODataMediaResult(this.query.execute(providedHttpClient, true));
	}
}
