/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.slf4j.Logger;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

@RequiredArgsConstructor
@EqualsAndHashCode
@Accessors( fluent = true )
class ODataRequestExecutor
{
    private static final Logger logger = CloudLoggerFactory.getLogger(ODataRequestExecutor.class);
    
    @NonNull
    private HttpClient httpClient;

    @NonNull
    private final URI uri;

    @Getter
    @Setter
    private ErrorResultHandler<?> errorHandler = null;
    
    @Getter
    @Setter
    private Map<String, String> headers = null;

    private String contentType = "application/json";

    public HttpResponse execute()
        throws ODataException
    {
    	HttpResponse response = null;
        try {
            response = initializeConnection();
            ODataConnectivityUtil.checkHttpStatus(response, errorHandler);
            return response;
        }
        catch(IllegalArgumentException e ) {
			HttpClientUtils.closeQuietly(response);
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Failed to execute " + toString() + ".", e);
        }
    }

    private HttpResponse initializeConnection()
        throws ODataException
    {
        final HttpRequestBase request = new HttpGet(uri);

        if( StringUtils.isNotEmpty(contentType) ) {
            request.setHeader(HttpHeaders.ACCEPT, contentType);
            if(headers != null) {
            	for (Entry<String, String> header : headers.entrySet()) {
        			request.setHeader(header.getKey(), header.getValue());
        		}
            }
        }

        try {
			return httpClient.execute(request);
		} catch (IOException e) {
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Failed to execute " + toString() + ".", e);
       }
    }
}
