/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import lombok.Getter;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import java.util.Date;

public class ODataType<T>
{
    @Getter
    private final T value;

    @Getter
    private final EdmSimpleTypeKind typeKind;

    @Getter
    private final Class<T> type;

    @SuppressWarnings( "unchecked" )
    private ODataType( final T value, final EdmSimpleTypeKind typeKind )
    {
        this.value = value;

        this.typeKind = typeKind;
        type = (Class<T>) value.getClass();
    }

    public ODataType( final T value )
    {
        this(value, null);
    }

    public static ODataType<String> of( final String value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.String);
    }

    public static ODataType<Long> of( final Long value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.Int64);
    }

    public static ODataType<Integer> of( final Integer value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.Int32);
    }

    public static ODataType<Double> of( final Double value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.Double);
    }

    public static ODataType<Float> of( final Float value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.Double);
    }

    public static ODataType<Boolean> of( final boolean value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.Boolean);
    }

    public static ODataType<LocalDate> of( final LocalDate value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.DateTime);
    }

    public static ODataType<LocalDateTime> of( final LocalDateTime value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.DateTime);
    }

    public static ODataType<DateTime> of( final DateTime value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.DateTime);
    }

    public static ODataType<Date> of( final Date value )
    {
        return new ODataType<>(value, EdmSimpleTypeKind.DateTime);
    }

    public static <T> ODataType<T> of( final T value )
    {
        return new ODataType<>(value);
    }

    @Override
    public String toString()
    {
        return value.toString();
    }
}
