/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity;

import org.apache.http.client.HttpClient;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;

public interface ODataUpdateRequest {

	/**
	 * Executes the OData PUT operation represented by this object.
	 * @param destinationName
	 * @return ODataUpdateResult
	 * @throws ODataException
	 * @deprecated As of version 1.15.0, replaced by execute(UpdateMethod updateMethod, String destinationName)
	 */
	@Deprecated
	public ODataUpdateResult execute(String destinationName) throws ODataException;
	
	/**
	 * Executes the OData PUT operation represented by this object. 
	 * @param withDestinationName
	 * @return ODataUpdateResult
	 * @throws ODataException
	 * @deprecated As of version 1.15.0, replaced by execute(UpdateMethod updateMethod, WithDestinationName withDestinationName)
	 */
	@Deprecated
	public ODataUpdateResult execute(final WithDestinationName withDestinationName) throws ODataException;
	
	/**
	 * Executes this Update request as a PUT or PATCH operation
	 * @param updateMethod An enum of type UpdateMethod, which determines whether the request is executed as a PUT or PATCH operation
	 * @param destinationName
	 * @return ODataUpdateResult
	 * @throws ODataException
	 */
	public ODataUpdateResult execute(UpdateMethod updateMethod, String destinationName) throws ODataException;
	
	/**
	 * Executes this Update request as PUT or PATCH operation
	 * @param updateMethod An enum of type UpdateMethod, which determines whether the request is executed as a PUT or PATCH operation
	 * @param withDestinationName
	 * @return ODataUpdateResult
	 * @throws ODataException
	 */
	public ODataUpdateResult execute(UpdateMethod updateMethod, WithDestinationName withDestinationName) throws ODataException;
	/**
	 * Executes this Update request as PUT or PATCH operation
	 * 
	 * @param updateMethod
	 *            An enum of type UpdateMethod, which determines whether the
	 *            request is executed as a PUT or PATCH operation
	 * @param providedClient
	 *            The HTTP Client instance that should be used for the HTTP
	 *            operations
	 * @return ODataUpdateResult
	 * @throws ODataException
	 */
	public ODataUpdateResult execute(UpdateMethod updateMethod, HttpClient providedClient) throws ODataException;
}

