package com.sap.cloud.sdk.odatav2.connectivity.api;

import org.apache.http.client.HttpClient;

import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;

public interface IODataQuery {

	/**
	 * Executes the OData query represented by this ODataQuery object.
	 * 
	 * @param providedClient
	 *            custom HttpClient capable of connecting to the data source
	 * @return ODataQueryResult represents the result of the query operation
	 * @throws ODataException
	 */
	ODataQueryResult execute(HttpClient providedClient) throws ODataException;

	/**
	 * Executes the OData query represented by this ODataQuery object.
	 * 
	 * @param providedClient
	 *            HttpClient capable of connecting to the data source
	 * @param isMediaRequest
	 *            indicates if the request is for a media resource
	 * @return ODataQueryResult represents the result of the query operation
	 * @throws ODataException
	 */
	ODataQueryResult execute(HttpClient providedClient, boolean isMediaRequest) throws ODataException;

	/**
	 * Executes the OData query represented by this ODataQuery object.
	 * 
	 * @param withDestinationName
	 * @return ODataQueryResult represents the result of the query operation.
	 * @throws ODataException
	 */
	ODataQueryResult execute(WithDestinationName withDestinationName) throws ODataException;

	/**
	 * Executes the OData query represented by this ODataQuery object.
	 * 
	 * @param destinationName
	 * @return ODataQueryResult represents the result of the query operation.
	 * @throws ODataException
	 */
	ODataQueryResult execute(String destinationName) throws ODataException;

	String toString();

	String getMetadataQuery();

}