package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions.FUNCTIONS;

public class MathFunction {
	/**
	 * Creates round function that returns the rounded property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue round(ODataProperty property) {
		return new NumValue(FUNCTIONS.ROUND, property, null);
	}
	/**
	 * Creates floor function that returns the floor value of the property
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue floor(ODataProperty property) {
		return new NumValue(FUNCTIONS.FLOOR, property, null);
	}
	/**
	 * Creates ceiling function that returns the ceiling value of the property
	 * @param property An ODataProperty object representing the property of an entity
	 * @return A NumValue object representing a filter function 
	 */
	public static NumValue ceiling(ODataProperty property) {
		return new NumValue(FUNCTIONS.CEILING, property, null);
	}
	/**
	 * Creates add function that adds a number to the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @param operand An ODataType object representing the number
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue add(ODataProperty property, ODataType operand) {
		return new NumValue(FUNCTIONS.ADD, property, operand);
	}
	/**
	 * Creates multiplication function that multiplies a number with the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @param operand An ODataType object representing the number
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue mul(ODataProperty property, ODataType operand) {
		return new NumValue(FUNCTIONS.MUL, property, operand);
	}
	/**
	 * Creates division function that divides the property value by a number
	 * @param property An ODataProperty object representing the property of an entity
	 * @param operand An ODataType object representing the number
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue div(ODataProperty property, ODataType operand) {
		return new NumValue(FUNCTIONS.DIV, property, operand);
	}
	/**
	 * Creates subtraction function that subtracts a number from the property value
	 * @param property An ODataProperty object representing the property of an entity
	 * @param operand An ODataType object representing the number
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue sub(ODataProperty property, ODataType operand) {
		return new NumValue(FUNCTIONS.SUB, property, operand);
	}
	/**
	 * Creates modulo function that calculates the remainder of a division of 
	 * the property value by a number
	 * @param property An ODataProperty object representing the property of an entity
	 * @param operand An ODataType object representing the number
	 * @return A NumValue object representing a filter function	 
	 */
	public static NumValue mod(ODataProperty property, ODataType operand) {
		return new NumValue(FUNCTIONS.MOD, property, operand);
	}
}
