/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;

public class UrlEncoder
{
    public static String encode(final String toBeEncoded )
    {
    	try {
         	String stringToBeEncoded = toBeEncoded;
         	if(toBeEncoded.contains("'")) {
         		if(toBeEncoded.length() == 1)
         			stringToBeEncoded = toBeEncoded.replace("'", "''");
         		else if(toBeEncoded.indexOf("'") == 0 && toBeEncoded.lastIndexOf("'") == toBeEncoded.length() -1) {
         			stringToBeEncoded = toBeEncoded.substring(1, toBeEncoded.length() -1).replace("'", "''");
         			stringToBeEncoded = "'" + stringToBeEncoded + "'";
         		}	
         		else
         			stringToBeEncoded = toBeEncoded.replace("'", "''");
         	}
         	return URLEncoder.encode(stringToBeEncoded, "UTF-8").replace("+", "%20");
         }
        catch( final UnsupportedEncodingException e ) {
            throw new ShouldNotHappenException(e);
        }
    }
}
