/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataCreateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataCreateRequestImpl;
import com.sap.cloud.servicesdk.prov.jacksonutil.JacksonMapper;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ODataCreateRequestBuilder {
    private String serviceName;
    private String entitySetName;
    private Map<String, Object> body = null;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> destinationRelevantHeaders = new HashMap<String, String>();
    private Boolean cacheMetadata = false;
    private String navigationProperty = null;
    private Map<String, Object> srcKeyMap = new HashMap<String, Object>();
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private boolean isCacheRefresh = false;

    private ODataCreateRequestBuilder(String serviceName, String entitySetName) {
        this.serviceName = serviceName;
        this.entitySetName = entitySetName;
    }

    public static ODataCreateRequestBuilder withEntity(String serviceName, String entitySetName) {
        return new ODataCreateRequestBuilder(serviceName, entitySetName);
    }

    @Deprecated
    public ODataCreateRequestBuilder withBody(Map<String, Object> entityData) {
        return this.setBody(entityData);
    }

    public ODataCreateRequestBuilder withBodyAsMap(Map<String, Object> entityData) {
        return this.setBody(entityData);
    }

    public ODataCreateRequestBuilder withErrorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ODataCreateRequestBuilder withHeader(String key, String value) {
        return this.withHeader(key, value, false);
    }

    public ODataCreateRequestBuilder withHeader(String key, String value, boolean passInAllRequests) {
        if (passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        if (key.equals("SAP-PASSPORT") && !passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        this.headers.put(key, value);
        return this;
    }

    public ODataCreateRequestBuilder enableMetadataCache() {
        this.cacheMetadata = true;
        return this;
    }

    public ODataCreateRequestBuilder enableMetadataCache(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
        this.cacheMetadata = true;
        return this;
    }

    public ODataCreateRequestBuilder withCacheRefresh() {
        this.isCacheRefresh = true;
        return this;
    }

    public ODataCreateRequestBuilder withMetadata(URL metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
        return this;
    }

    private ODataCreateRequestBuilder setBody(Map<String, Object> entityData) {
        this.body = entityData;
        return this;
    }

    public ODataCreateRequest build() {
        if (this.navigationProperty == null && this.srcKeyMap == null) {
            return new ODataCreateRequestImpl(this.serviceName, this.entitySetName, this.body, this.errorHandler, this.headers, this.destinationRelevantHeaders, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        }
        return new ODataCreateRequestImpl(this.serviceName, this.entitySetName, this.body, this.navigationProperty, this.srcKeyMap, this.errorHandler, this.headers, this.destinationRelevantHeaders, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
    }

    public ODataCreateRequestBuilder withBodyAs(Object pojoData) {
        ObjectMapper mapper = JacksonMapper.getMapper();
        HashMap pojoInMap = (HashMap)mapper.convertValue(pojoData, HashMap.class);
        this.setBody(pojoInMap);
        return this;
    }

    public ODataCreateRequestBuilder onNavigationProperty(String navigationProperty, Map<String, Object> keyMap) {
        this.navigationProperty = navigationProperty;
        this.srcKeyMap = keyMap;
        return this;
    }
}

