/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataReadMediaRequest;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ODataReadMediaBuilder {
    private final String servicePath;
    private final String entity;
    private boolean cacheMetadata = false;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean useMetadata = true;
    private ErrorResultHandler<?> errorHandler;
    private final Map<String, Object> queryParams = Maps.newHashMap();
    private Map<String, Object> keys;
    private Map<String, String> destinationRelevantHeaders = new HashMap<String, String>();
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private boolean isCacheRefresh = false;

    private ODataReadMediaBuilder(String servicePath, String entity, Map<String, Object> keys) {
        this.servicePath = servicePath;
        this.entity = entity;
        this.keys = keys;
    }

    public static ODataReadMediaBuilder withEntity(String servicePath, String entitySetName, Map<String, Object> keys) {
        return new ODataReadMediaBuilder(servicePath, entitySetName, keys);
    }

    public ODataReadMediaBuilder enableMetadataCache() {
        this.cacheMetadata = true;
        return this;
    }

    public ODataReadMediaBuilder enableMetadataCache(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
        this.cacheMetadata = true;
        return this;
    }

    public ODataReadMediaBuilder withCacheRefresh() {
        this.isCacheRefresh = true;
        return this;
    }

    public ODataReadMediaBuilder withMetadata(URL metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
        return this;
    }

    public ODataReadMediaBuilder withHeader(String key, String value) {
        return this.withHeader(key, value, false);
    }

    public ODataReadMediaBuilder withHeader(String key, String value, boolean passInAllRequests) {
        if (passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        if (key.equals("SAP-PASSPORT") && !passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        this.headers.put(key, value);
        return this;
    }

    public ODataReadMediaBuilder withoutMetadata() {
        this.useMetadata = false;
        return this;
    }

    public ODataReadMediaBuilder param(String key, Object value) {
        this.queryParams.put(key, value);
        return this;
    }

    public ODataReadMediaRequest build() {
        if (this.keys != null) {
            this.useMetadata = true;
        }
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity(this.servicePath, this.entity);
        ODataQueryBuilder.ODataQueryResolver resolver = builder.new ODataQueryBuilder.ODataQueryResolver();
        ODataQuery query = new ODataQuery(this.servicePath, this.entity, this.keys, resolver, this.errorHandler, this.headers, this.destinationRelevantHeaders, this.useMetadata, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        return new ODataReadMediaRequest(query);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataReadMediaBuilder)) {
            return false;
        }
        ODataReadMediaBuilder other = (ODataReadMediaBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$servicePath = this.servicePath;
        String other$servicePath = other.servicePath;
        if (this$servicePath == null ? other$servicePath != null : !this$servicePath.equals(other$servicePath)) {
            return false;
        }
        String this$entity = this.entity;
        String other$entity = other.entity;
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        if (this.cacheMetadata != other.cacheMetadata) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (this.useMetadata != other.useMetadata) {
            return false;
        }
        ErrorResultHandler<?> this$errorHandler = this.errorHandler;
        ErrorResultHandler<?> other$errorHandler = other.errorHandler;
        if (this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler)) {
            return false;
        }
        Map<String, Object> this$queryParams = this.queryParams;
        Map<String, Object> other$queryParams = other.queryParams;
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        Map<String, Object> this$keys = this.keys;
        Map<String, Object> other$keys = other.keys;
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        Map<String, String> this$destinationRelevantHeaders = this.destinationRelevantHeaders;
        Map<String, String> other$destinationRelevantHeaders = other.destinationRelevantHeaders;
        if (this$destinationRelevantHeaders == null ? other$destinationRelevantHeaders != null : !((Object)this$destinationRelevantHeaders).equals(other$destinationRelevantHeaders)) {
            return false;
        }
        URL this$metadataFilePath = this.metadataFilePath;
        URL other$metadataFilePath = other.metadataFilePath;
        if (this$metadataFilePath == null ? other$metadataFilePath != null : !((Object)this$metadataFilePath).equals(other$metadataFilePath)) {
            return false;
        }
        CacheKey this$cacheKey = this.cacheKey;
        CacheKey other$cacheKey = other.cacheKey;
        if (this$cacheKey == null ? other$cacheKey != null : !this$cacheKey.equals(other$cacheKey)) {
            return false;
        }
        return this.isCacheRefresh == other.isCacheRefresh;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODataReadMediaBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $servicePath = this.servicePath;
        result = result * 59 + ($servicePath == null ? 43 : $servicePath.hashCode());
        String $entity = this.entity;
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        result = result * 59 + (this.cacheMetadata ? 79 : 97);
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + (this.useMetadata ? 79 : 97);
        ErrorResultHandler<?> $errorHandler = this.errorHandler;
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        Map<String, Object> $queryParams = this.queryParams;
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        Map<String, Object> $keys = this.keys;
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        Map<String, String> $destinationRelevantHeaders = this.destinationRelevantHeaders;
        result = result * 59 + ($destinationRelevantHeaders == null ? 43 : ((Object)$destinationRelevantHeaders).hashCode());
        URL $metadataFilePath = this.metadataFilePath;
        result = result * 59 + ($metadataFilePath == null ? 43 : ((Object)$metadataFilePath).hashCode());
        CacheKey $cacheKey = this.cacheKey;
        result = result * 59 + ($cacheKey == null ? 43 : $cacheKey.hashCode());
        result = result * 59 + (this.isCacheRefresh ? 79 : 97);
        return result;
    }

    public ODataReadMediaBuilder useMetadata(boolean useMetadata) {
        this.useMetadata = useMetadata;
        return this;
    }

    public ODataReadMediaBuilder errorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }
}

