/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.impl;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataCreateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataCreateResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataDeleteRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataDeleteResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataUpdateResult;
import com.sap.cloud.sdk.odatav2.connectivity.UpdateMethod;
import com.sap.cloud.sdk.odatav2.connectivity.batch.BatchRequest;
import com.sap.cloud.sdk.odatav2.connectivity.batch.BatchResult;
import com.sap.cloud.sdk.odatav2.connectivity.batch.BatchResultPart;
import com.sap.cloud.sdk.odatav2.connectivity.batch.ChangeSetResultPart;
import com.sap.cloud.sdk.odatav2.connectivity.impl.BatchQueryResultImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.BatchResultImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.BatchResultPartWrapper;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ChangeSetRequestImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ChangeSetResultImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ChangeSetUpdateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataCreateRequestImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataDeleteRequestImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataQueryImpl;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataUpdateRequestImpl;
import com.sap.cloud.sdk.odatav2.connectivity.internal.EdmWithCSRF;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataHttpResponseWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSet;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.api.client.batch.BatchPart;
import org.apache.olingo.odata2.api.client.batch.BatchQueryPart;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.ep.DeserializerProperties;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.client.api.ep.EntityStream;
import org.slf4j.Logger;

public class BatchRequestImpl<E>
implements BatchRequest {
    private static final Logger logger = CloudLoggerFactory.getLogger(BatchRequestImpl.class);
    private Edm edm = null;
    private ErrorResultHandler<?> errorHandler;
    Map<String, String> headers;
    private Map<String, String> destinationRelevantHeaders;
    private Boolean cacheMetadata;
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private Boolean isCacheRefresh;
    private static final String APPLICATION_JSON = "application/json";
    private List batch;
    private List requests = new ArrayList();
    private String servicePath;
    private static final String BOUNDARY = "batch_123";
    private static final String DOLLAR_BATCH = "/$batch";
    private static final String multipart = "multipart/mixed;boundary=";
    private static final String CRLF = "\r\n";
    private static final String UTF_8 = "UTF-8";
    @NonNull
    private HttpClient httpClient = new DefaultHttpClient();
    private int reqCounter;
    private int resCounter;
    private EdmEntitySet lastEntityMetadata;
    public static final String SEPARATOR_PATH = "/";

    public BatchRequestImpl(ErrorResultHandler<?> errorHandler, Map<String, String> destinationRelevantHeaders, Boolean cacheMetadata, URL metadataFilePath, CacheKey cacheKey, Map<String, String> headers, Boolean isCacheRefresh, List batch, String servicePath) {
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.cacheMetadata = cacheMetadata;
        this.metadataFilePath = metadataFilePath;
        this.cacheKey = cacheKey;
        this.isCacheRefresh = isCacheRefresh;
        this.batch = batch;
        this.servicePath = servicePath;
    }

    public BatchRequestImpl(List batch, String servicePath) {
        this.batch = batch;
        this.servicePath = servicePath;
    }

    protected HttpClient getHttpClient(String destinationName) {
        Destination dest = (Destination)DestinationAccessor.tryGetDestination((String)destinationName).get();
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)dest.asHttp());
    }

    public BatchResult handleExecute(HttpClient httpClient, String destinationName) throws ODataException {
        InputStream inputStream;
        HttpResponse batchResponse;
        this.httpClient = destinationName == null ? httpClient : this.getHttpClient(destinationName);
        EdmWithCSRF edmWithCsrf = this.fetchEdm(destinationName);
        this.edm = edmWithCsrf.getEdm();
        ArrayList<Object> batchRequests = new ArrayList<Object>();
        for (Object batchReq : this.batch) {
            if (batchReq instanceof ChangeSetRequestImpl) {
                BatchChangeSet changeSet = BatchChangeSet.newBuilder().build();
                ChangeSetRequestImpl c = (ChangeSetRequestImpl)batchReq;
                ArrayList reqList = c.getRequests();
                Iterator<Object> reqs = reqList.iterator();
                while (reqs.hasNext()) {
                    Object var11_12 = null;
                    Header[] next = (Header[])reqs.next();
                    if (next == null) break;
                    for (Object e : next) {
                        this.requests.add(e);
                        HashMap<String, String> changeSetHeaders = new HashMap<String, String>();
                        changeSetHeaders.put("Content-Type", "application/json;odata=verbose");
                        changeSetHeaders.put("Accept", "application/json;odata=verbose");
                        if (e instanceof ODataCreateRequest) {
                            changeSet.add(this.createRequest((ODataCreateRequest)e, changeSetHeaders));
                            continue;
                        }
                        if (e instanceof ChangeSetUpdateRequest) {
                            changeSet.add(this.updateRequest((ChangeSetUpdateRequest)e, changeSetHeaders));
                            continue;
                        }
                        if (e instanceof ODataDeleteRequest) {
                            changeSet.add(this.deleteRequest((ODataDeleteRequest)e, changeSetHeaders));
                            continue;
                        }
                        throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Invalid Request : " + e);
                    }
                }
                if (changeSet.getChangeSetParts() == null || changeSet.getChangeSetParts().isEmpty()) continue;
                batchRequests.add(changeSet);
                continue;
            }
            if (batchReq instanceof ODataQuery) {
                ODataQueryImpl odataQuery = (ODataQueryImpl)batchReq;
                this.requests.add(odataQuery);
                batchRequests.add(this.getRequest(odataQuery));
                continue;
            }
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Invalid Request : " + batchReq);
        }
        InputStream body = EntityProvider.writeBatchRequest(batchRequests, (String)BOUNDARY);
        String bodyAsString = BatchRequestImpl.inputStreamToStringCRLFLineBreaks(body);
        logger.info(bodyAsString);
        URI uri = URI.create(this.servicePath + DOLLAR_BATCH);
        HttpPost post = new HttpPost(uri);
        Map<String, String> headersMap = this.headers;
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry entry : headersMap.entrySet()) {
                post.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((batchResponse = this.executeBatch(bodyAsString, this.httpClient, edmWithCsrf.getCsrfToken(), post)) == null || batchResponse.getEntity() == null) {
            throw new ODataException(ODataExceptionType.BATCH_EXCEPTION, "Null response received from endpoint");
        }
        if (batchResponse != null && batchResponse.getStatusLine() != null && batchResponse.getStatusLine().getStatusCode() >= 400) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Header headers : batchResponse.getAllHeaders()) {
                stringBuilder.append(headers.getName() + ":" + headers.getValue() + ", ");
            }
            ODataException ex = new ODataException(ODataExceptionType.BATCH_EXCEPTION, stringBuilder.toString());
            ex.setCode(Integer.toString(batchResponse.getStatusLine().getStatusCode()));
            ex.setMessage(batchResponse.getStatusLine().toString());
            try {
                ex.setHttpErrorResponseBody(IOUtils.toString((InputStream)batchResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
            }
            throw ex;
        }
        try {
            inputStream = batchResponse.getEntity().getContent();
        }
        catch (IOException | UnsupportedOperationException e1) {
            logger.error(e1.getMessage());
            HttpClientUtils.closeQuietly((HttpResponse)batchResponse);
            throw new ODataException(ODataExceptionType.BATCH_EXCEPTION, e1.getMessage(), e1);
        }
        String content = batchResponse.getFirstHeader("Content-Type").getValue();
        ArrayList<BatchResultPart> arrayList = new ArrayList<BatchResultPart>();
        try {
            List responses = EntityProvider.parseBatchResponse((InputStream)inputStream, (String)content);
            this.reqCounter = 0;
            this.resCounter = 0;
            for (BatchPart batchPart : batchRequests) {
                this.createBatchResult(batchPart, responses, arrayList);
            }
        }
        catch (BatchException e) {
            logger.error(e.getMessage());
            throw new ODataException(ODataExceptionType.RESPONSE_DESERIALIZATION_FAILED, e.getMessage(), e);
        }
        finally {
            ODataConnectivityUtil.closeQuietly(batchResponse, (HttpRequestBase)post);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return new BatchResultImpl(arrayList);
    }

    private BatchPart getRequest(ODataQueryImpl odataQuery) throws ODataException {
        StringBuilder keysUrl = new StringBuilder(odataQuery.getEntity());
        if (odataQuery.getKeys() != null) {
            EdmEntityType entityType = this.getEntityType(this.edm, keysUrl.toString());
            keysUrl.append("(");
            keysUrl.append(this.convertKeyValuesToString(odataQuery.getKeys(), entityType));
            keysUrl.append(")");
        }
        if (odataQuery.getNavigations().size() > 0) {
            String withSeperator = ODataConnectivityUtil.withSeparator(SEPARATOR_PATH, odataQuery.getEntity(), null);
            try {
                withSeperator = odataQuery.addNavigations("");
                keysUrl.append(withSeperator);
            }
            catch (Exception exc) {
                logger.error(exc.getMessage());
            }
        }
        try {
            String systemQuery = odataQuery.getoDataQueryResolver().getQuery(null);
            if (systemQuery != null) {
                if (systemQuery.compareTo("$format=json&$count=true") == 0) {
                    systemQuery = "$count";
                    systemQuery = URLEncoder.encode(systemQuery, UTF_8);
                    keysUrl.append(SEPARATOR_PATH);
                } else {
                    if (systemQuery.indexOf("$format=json&$count=true") != -1) {
                        systemQuery = systemQuery.substring(0, systemQuery.indexOf("$format=json&$count=true") - 1);
                        keysUrl.append("/$count");
                    }
                    systemQuery = URLEncoder.encode(systemQuery, UTF_8);
                    keysUrl.append("?");
                }
                keysUrl.append(systemQuery);
            }
        }
        catch (UnsupportedEncodingException | EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", e);
        }
        HashMap<String, String> batchHeaders = new HashMap<String, String>();
        batchHeaders.put("Accept", "application/json;odata=verbose");
        batchHeaders.putAll(odataQuery.getHeaders());
        return BatchQueryPart.method((String)ODataHttpMethod.GET.name()).uri(keysUrl.toString()).headers(batchHeaders).build();
    }

    private BatchChangeSetPart deleteRequest(ODataDeleteRequest request, Map<String, String> changeSetHeaders) throws ODataException {
        ODataDeleteRequestImpl dr = (ODataDeleteRequestImpl)request;
        EdmEntityType entityType = this.getEntityType(this.edm, dr.getEntitySetName());
        changeSetHeaders.putAll(dr.getHeaders());
        String keysUrl = "(" + this.convertKeyValuesToString(dr.getKeys(), entityType) + ")";
        return BatchChangeSetPart.method((String)ODataHttpMethod.DELETE.name()).uri(dr.getServiceName() + SEPARATOR_PATH + dr.getEntitySetName() + keysUrl).headers(changeSetHeaders).build();
    }

    private BatchChangeSetPart updateRequest(ChangeSetUpdateRequest request, Map<String, String> changeSetHeaders) throws ODataException {
        ODataUpdateRequestImpl ur = (ODataUpdateRequestImpl)request.getRequest();
        UpdateMethod method = request.getMethod();
        String entitySetName = ur.getEntitySetName();
        EdmEntitySet eSet = null;
        Entity entity = null;
        EdmEntitySet targetEtySet = null;
        EdmEntityType entityType = null;
        try {
            eSet = this.edm.getDefaultEntityContainer().getEntitySet(entitySetName);
            if (eSet == null) {
                throw new ODataException(ODataExceptionType.INVALID_ENTITY_NAME, "No entity with name " + entitySetName + " in the OData service", null);
            }
            entityType = eSet.getEntityType();
            entity = ODataConnectivityUtil.addPropertiesToEntity(ur.getBody(), entityType);
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
        String entityString = this.getPayloadAsString(eSet, entity, targetEtySet);
        String keysUrl = "(" + this.convertKeyValuesToString(ur.getKeys(), entityType) + ")";
        changeSetHeaders.putAll(ur.getHeaders());
        return BatchChangeSetPart.method((String)method.name()).uri(ur.getServiceName() + SEPARATOR_PATH + ur.getEntitySetName() + keysUrl).body(entityString).headers(changeSetHeaders).build();
    }

    private BatchChangeSetPart createRequest(ODataCreateRequest request, Map<String, String> changeSetHeaders) throws ODataException {
        ODataCreateRequestImpl cr = (ODataCreateRequestImpl)request;
        String entitySetName = cr.getEntitySet();
        String navigationName = cr.getNavigationProperty();
        EdmEntitySet eSet = null;
        Entity entity = null;
        EdmEntitySet targetEtySet = null;
        EdmEntityType entityType = null;
        try {
            eSet = this.edm.getDefaultEntityContainer().getEntitySet(entitySetName);
            if (eSet == null) {
                throw new ODataException(ODataExceptionType.INVALID_ENTITY_NAME, "No entity with name " + entitySetName + " in the OData service", null);
            }
            entityType = eSet.getEntityType();
            boolean isNavigationFlow = navigationName != null;
            EdmNavigationProperty navigationProperty = null;
            if (isNavigationFlow) {
                navigationProperty = cr.getNavigationProperty(eSet);
            }
            EdmEntityType childEntityType = null;
            if (navigationProperty != null) {
                childEntityType = this.getTargetEntityType(this.edm, eSet, navigationProperty);
                targetEtySet = cr.getTargetEntitySet(this.edm, eSet, navigationProperty);
            }
            entity = childEntityType != null ? ODataConnectivityUtil.addPropertiesToEntity(cr.getBody(), childEntityType) : ODataConnectivityUtil.addPropertiesToEntity(cr.getBody(), entityType);
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
        String entityString = this.getPayloadAsString(eSet, entity, targetEtySet);
        String completeUrl = cr.getServiceName() + SEPARATOR_PATH + entitySetName;
        try {
            completeUrl = cr.handleNavigation(completeUrl, entityType);
        }
        catch (EdmException e) {
            logger.error(e.getMessage());
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
        changeSetHeaders.putAll(cr.getHeaders());
        return BatchChangeSetPart.method((String)ODataHttpMethod.POST.name()).uri(completeUrl).body(entityString).headers(changeSetHeaders).build();
    }

    private String getPayloadAsString(EdmEntitySet eSet, Entity entity, EdmEntitySet targetEtySet) throws ODataException {
        ODataResponse response;
        entity.setWriteProperties(EntitySerializerProperties.serviceRoot((URI)URI.create(this.servicePath)).build());
        try {
            eSet = targetEtySet != null ? targetEtySet : eSet;
            response = ODataClient.newInstance().createSerializer(APPLICATION_JSON).writeEntry(eSet, entity);
        }
        catch (EntityProviderException e) {
            throw new ODataException(ODataExceptionType.INPUT_DATA_SERIALIZATION_FAILED, "Error during serialization of input payload. " + e.getMessage(), e);
        }
        InputStream inputStream = ODataConnectivityUtil.getObjectStream(response.getEntity());
        String entityString = null;
        if (inputStream != null) {
            entityString = BatchRequestImpl.inputStreamToStringCRLFLineBreaks(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error("Error while closing the inputstream", (Throwable)e);
            }
        }
        return entityString;
    }

    private EdmWithCSRF fetchEdm(String destinationName) throws ODataException {
        EdmWithCSRF edmWithCSRF = null;
        try {
            this.cacheMetadata = this.cacheMetadata == null ? false : this.cacheMetadata;
            this.isCacheRefresh = this.isCacheRefresh == null ? false : this.isCacheRefresh;
            edmWithCSRF = ODataConnectivityUtil.readMetadataWithCSRF(this.servicePath, this.httpClient, this.headers, this.errorHandler, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        }
        catch (IOException e) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", e);
        }
        if (edmWithCSRF == null || edmWithCSRF.getEdm() == null) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", null);
        }
        return edmWithCSRF;
    }

    private String convertKeyValuesToString(Map<String, Object> keys, EdmEntityType entityType) throws ODataException {
        String keyPredicateString = "";
        for (Map.Entry<String, Object> e : keys.entrySet()) {
            if (!keyPredicateString.isEmpty()) {
                keyPredicateString = keyPredicateString + ',';
            }
            String key = e.getKey();
            Object value = e.getValue();
            String convertedValue = new String();
            try {
                EdmProperty prop = (EdmProperty)entityType.getProperty(key);
                EdmSimpleType type = (EdmSimpleType)prop.getType();
                convertedValue = type.toUriLiteral(type.valueToString(value, EdmLiteralKind.DEFAULT, prop.getFacets()));
            }
            catch (EdmException exp) {
                throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", exp);
            }
            keyPredicateString = keyPredicateString + key + '=' + convertedValue;
        }
        return keyPredicateString;
    }

    private EdmEntityType getEntityType(Edm edm, String entitySetName) throws ODataException {
        try {
            EdmEntitySet entitySet = edm.getDefaultEntityContainer().getEntitySet(entitySetName);
            if (entitySet == null) {
                throw new ODataException(ODataExceptionType.INVALID_ENTITY_NAME, "No entity with name " + entitySetName + " in the OData service", null);
            }
            return edm.getDefaultEntityContainer().getEntitySet(entitySetName).getEntityType();
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
    }

    private EdmEntityType getTargetEntityType(Edm edm, EdmEntitySet srcEtySet, EdmNavigationProperty navigationProp) throws EdmException {
        if (navigationProp == null) {
            return null;
        }
        String toRole = navigationProp.getToRole();
        return navigationProp.getRelationship().getEnd(toRole).getEntityType();
    }

    private void createBatchResult(BatchPart request, List<BatchSingleResponse> responses, List<BatchResultPart> batchResponsePartList) throws ODataException {
        BatchSingleResponse response = responses.get(this.resCounter);
        if (request instanceof BatchQueryPart) {
            int status = Integer.parseInt(response.getStatusCode());
            BatchResultPart batchResultPart = null;
            if (status >= 400) {
                batchResultPart = new BatchResultPartWrapper(this.fetchHeaders(response), status, new ODataException(ODataExceptionType.BATCH_EXCEPTION, response.getBody()));
            } else {
                try {
                    if (this.requests.get(this.reqCounter) instanceof ODataQuery) {
                        this.lastEntityMetadata = ((ODataQueryImpl)this.requests.get(this.reqCounter)).updateNavigationType(this.edm);
                    }
                    batchResultPart = new BatchQueryResultImpl(response.getBody(), this.fetchHeaders(response), status, this.lastEntityMetadata);
                }
                catch (EdmException e) {
                    logger.error(e.getMessage());
                }
            }
            batchResponsePartList.add(batchResultPart);
            ++this.resCounter;
            ++this.reqCounter;
        } else if (request instanceof BatchChangeSet) {
            ODataHttpResponseWrapper changeSetResultPart = null;
            ArrayList<ChangeSetResultPart> changeSetResultParts = new ArrayList<ChangeSetResultPart>();
            BatchResultPart changeSetResult = new ChangeSetResultImpl(changeSetResultParts);
            List changeSetParts = ((BatchChangeSet)request).getChangeSetParts();
            int status = 0;
            for (BatchChangeSetPart changeSetPart : changeSetParts) {
                response = responses.get(this.resCounter);
                status = Integer.valueOf(response.getStatusCode());
                Map<String, List<String>> headers = this.fetchHeaders(response);
                if (status < 400) {
                    if (!(changeSetPart instanceof BatchChangeSetPart)) continue;
                    if (ODataHttpMethod.POST.name().equals(changeSetPart.getMethod())) {
                        changeSetResultPart = new ODataCreateResult(this.fetchResponseData(response).getProperties(), headers, status);
                    } else if (ODataHttpMethod.PUT.name().equals(changeSetPart.getMethod()) || ODataHttpMethod.PATCH.name().equals(changeSetPart.getMethod()) || ODataHttpMethod.MERGE.name().equals(changeSetPart.getMethod())) {
                        changeSetResultPart = new ODataUpdateResult(headers, status);
                    } else if (ODataHttpMethod.DELETE.name().equals(changeSetPart.getMethod())) {
                        changeSetResultPart = new ODataDeleteResult(headers, status);
                    } else {
                        throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Invalid Request : " + changeSetPart);
                    }
                    changeSetResultParts.add((ChangeSetResultPart)((Object)changeSetResultPart));
                    ++this.resCounter;
                    ++this.reqCounter;
                    continue;
                }
                changeSetResult = new BatchResultPartWrapper(this.fetchHeaders(response), status, new ODataException(ODataExceptionType.BATCH_EXCEPTION, response.getBody()));
                ++this.resCounter;
                this.reqCounter += changeSetParts.size();
                break;
            }
            batchResponsePartList.add(changeSetResult);
        } else {
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Invalid Request : " + request);
        }
    }

    private ODataEntry fetchResponseData(BatchSingleResponse batchSingleResponse) throws ODataException {
        EntityStream entityStream = new EntityStream();
        ByteArrayInputStream stream = new ByteArrayInputStream(batchSingleResponse.getBody().getBytes(StandardCharsets.UTF_8));
        entityStream.setContent((InputStream)stream);
        entityStream.setReadProperties(DeserializerProperties.init().build());
        ODataCreateRequestImpl req = (ODataCreateRequestImpl)this.requests.get(this.reqCounter);
        String entitysetName = req.getEntitySet();
        try {
            EdmEntitySet entitySet = this.edm.getDefaultEntityContainer().getEntitySet(entitysetName);
            EdmNavigationProperty navProperty = null;
            if (req.getNavigationProperty() != null) {
                navProperty = req.getNavigationProperty(entitySet);
            }
            if (navProperty != null) {
                entitySet = req.getTargetEntitySet(this.edm, entitySet, navProperty);
            }
            return ODataClient.newInstance().createDeserializer(APPLICATION_JSON).readEntry(entitySet, entityStream);
        }
        catch (EdmException | EntityProviderException e) {
            throw new ODataException(ODataExceptionType.RESPONSE_DESERIALIZATION_FAILED, e.getMessage(), e);
        }
    }

    private Map<String, List<String>> fetchHeaders(BatchSingleResponse response) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Map headerMap = response.getHeaders();
        if (headerMap != null) {
            for (Map.Entry header : headerMap.entrySet()) {
                ArrayList<String> headerValueList = new ArrayList<String>();
                headerValueList.addAll(Arrays.asList((String)header.getValue()));
                headers.put((String)header.getKey(), (List<String>)(headerValueList.isEmpty() ? null : headerValueList));
            }
        }
        return headers;
    }

    @Override
    public BatchResult execute(String destinationName) throws ODataException {
        return this.handleExecute(null, destinationName);
    }

    private HttpResponse executeBatch(String body, HttpClient httpClient, String csrf, HttpPost post) throws ODataException {
        return this.execute((HttpEntity)new StringEntity(body, UTF_8), httpClient, csrf, post);
    }

    private HttpResponse execute(HttpEntity entity, HttpClient httpClient, String csrf, HttpPost post) throws ODataException {
        HttpResponse httpResponse = null;
        post.setHeader("x-csrf-token", csrf);
        post.setHeader("Content-Type", "multipart/mixed;boundary=batch_123");
        post.setEntity(entity);
        try {
            httpResponse = httpClient.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)post);
            throw new ODataException(ODataExceptionType.BATCH_EXCEPTION, "IOException", e);
        }
        return httpResponse;
    }

    public static String inputStreamToStringCRLFLineBreaks(InputStream in) throws ODataException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, Charset.forName(UTF_8)));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(CRLF);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new ODataException(ODataExceptionType.BATCH_EXCEPTION, "Error while parsing the Body.", e);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                logger.error("Error while clossing the buffer.", (Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public BatchResult execute(WithDestinationName withDestinationName) throws ODataException {
        return this.execute(withDestinationName.getDestinationName());
    }

    @Override
    public BatchResult execute(HttpClient providedClient) throws ODataException {
        this.httpClient = providedClient;
        return this.handleExecute(providedClient, null);
    }
}

