/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.GuavaMetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.MetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.internal.EdmWithCSRF;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataExceptionInternalResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.internal.UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataConnectivityUtil {
    private static Logger logger = LoggerFactory.getLogger(ODataConnectivityUtil.class);
    public static final String CSRF_HEADER = "x-csrf-token";
    private static MetadataCache metadataCache = new GuavaMetadataCache();
    public static final String SEPARATOR_PATH = "/";
    static final int HTTP_CODE_ERROR_MIN = 400;
    static final int HTTP_CODE_ERROR_MAX = 599;
    private static final int HTTP_CODE_METHOD_NOT_ALLOWED = 405;

    public static EdmWithCSRF readMetadataWithCSRF(String serviceUri, HttpClient httpClient, Map<String, String> headers, ErrorResultHandler<?> errorHandler, Boolean cacheMetadata, URL metadataFilePath, CacheKey cacheKey, Boolean isCacheRefresh) throws ClientProtocolException, IOException, ODataException {
        EdmWithCSRF edmWithCSRF;
        EdmWithCSRF edmWithCSRF2 = null;
        HttpResponse httpResponse = null;
        HttpHead httpGet = new HttpHead(serviceUri);
        try {
            Edm edm = metadataCache.getEdm(serviceUri + "/$metadata", httpClient, headers, errorHandler, cacheMetadata, metadataFilePath, cacheKey, isCacheRefresh);
            httpGet.setHeader(CSRF_HEADER, "Fetch");
            if (headers != null) {
                for (Map.Entry<String, String> e : headers.entrySet()) {
                    httpGet.addHeader(e.getKey(), e.getValue());
                }
            }
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            ODataConnectivityUtil.checkHttpResponseForCSRF(httpResponse, errorHandler);
            Header csrfHeader = httpResponse.getFirstHeader(CSRF_HEADER);
            String csrfToken = csrfHeader == null ? null : csrfHeader.getValue();
            edmWithCSRF = edmWithCSRF2 = new EdmWithCSRF(edm, csrfToken);
        }
        catch (Exception e) {
            try {
                logger.error("Error occurred during create operation of Type : " + e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)httpGet);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)httpGet);
        return edmWithCSRF;
    }

    public static EdmWithCSRF readMetadataWithCSRF(String serviceUri, HttpClient httpClient, Map<String, String> headers, ErrorResultHandler<?> errorHandler, Boolean cacheMetadata, URL metadataFilePath) throws ClientProtocolException, IOException, ODataException {
        return ODataConnectivityUtil.readMetadataWithCSRF(serviceUri, httpClient, headers, errorHandler, cacheMetadata, metadataFilePath, null, false);
    }

    public static String convertKeyValuesToString(Map<String, Object> keys, EdmEntityType entityType) throws ODataException, EdmException {
        String keyPredicateString = "";
        for (Map.Entry<String, Object> e : keys.entrySet()) {
            String convertedValue;
            if (!keyPredicateString.isEmpty()) {
                keyPredicateString = keyPredicateString + ',';
            }
            String key = e.getKey();
            Object value = e.getValue();
            EdmProperty prop = (EdmProperty)entityType.getProperty(key);
            if (prop == null) {
                throw new ODataException(ODataExceptionType.KEY_NOT_PRESENT, "No such key property. " + key, null);
            }
            EdmSimpleType type = (EdmSimpleType)prop.getType();
            try {
                if ("String".equals(type.getName()) && value != null) {
                    value = UrlEncoder.encode(value.toString());
                }
                convertedValue = type.toUriLiteral(type.valueToString(value, EdmLiteralKind.DEFAULT, prop.getFacets()));
            }
            catch (EdmSimpleTypeException e1) {
                throw new ODataException(ODataExceptionType.BAD_KEY_VALUE, e1.getMessage(), e1);
            }
            keyPredicateString = keyPredicateString + key + '=' + convertedValue;
        }
        return keyPredicateString;
    }

    public static Entity addPropertiesToEntity(Map<String, Object> properties, EdmEntityType entityType) throws EdmException, ODataException {
        Entity entity = new Entity();
        List navigationProperties = entityType.getNavigationPropertyNames();
        List propertiesInEntity = entityType.getPropertyNames();
        Iterator<String> keySetIterator = properties.keySet().iterator();
        while (keySetIterator.hasNext()) {
            String propertyName = keySetIterator.next().toString();
            if (navigationProperties.contains(propertyName)) {
                EdmNavigationProperty navigationProperty = (EdmNavigationProperty)entityType.getProperty(propertyName);
                EdmEntityType targetType = navigationProperty.getRelationship().getEnd(navigationProperty.getToRole()).getEntityType();
                if (navigationProperty.getMultiplicity().equals((Object)EdmMultiplicity.MANY)) {
                    ArrayList<Map<String, Object>> childEntities = null;
                    if (properties.get(propertyName) instanceof List) {
                        childEntities = (ArrayList<Map<String, Object>>)properties.get(propertyName);
                    } else if (properties.get(propertyName) instanceof Map) {
                        childEntities = new ArrayList<Map<String, Object>>();
                        childEntities.add((Map)properties.get(propertyName));
                    } else if (properties.get(propertyName) instanceof ODataFeed) {
                        ODataFeed feed = (ODataFeed)properties.get(propertyName);
                        childEntities = new ArrayList();
                        for (ODataEntry oDataEntry : feed.getEntries()) {
                            childEntities.add(ODataConnectivityUtil.mapEntryToMap(oDataEntry));
                        }
                    }
                    EntityCollection deepInsertChildren = new EntityCollection();
                    for (Map map : childEntities) {
                        deepInsertChildren.addEntity(ODataConnectivityUtil.addPropertiesToEntity(map, targetType));
                    }
                    entity.addNavigation(propertyName, (Object)deepInsertChildren);
                    continue;
                }
                Map<String, Object> childEntity = null;
                if (properties.get(propertyName) instanceof List) {
                    childEntity = (Map<String, Object>)((List)properties.get(propertyName)).get(0);
                } else if (properties.get(propertyName) instanceof Map) {
                    childEntity = (Map)properties.get(propertyName);
                } else if (properties.get(propertyName) instanceof ODataEntry) {
                    ODataEntry entryFeed = (ODataEntry)properties.get(propertyName);
                    childEntity = ODataConnectivityUtil.mapEntryToMap(entryFeed);
                }
                entity.addNavigation(propertyName, (Object)ODataConnectivityUtil.addPropertiesToEntity(childEntity, targetType));
                continue;
            }
            if (!propertiesInEntity.contains(propertyName)) {
                throw new ODataException(ODataExceptionType.INVALID_PROPERTY_NAME, "No property with name " + propertyName + " present in the entity", null);
            }
            if (properties.get(propertyName) instanceof Map) {
                entity.addProperty(propertyName, ODataConnectivityUtil.addPropertiesToMap((Map)properties.get(propertyName)));
                continue;
            }
            entity.addProperty(propertyName, properties.get(propertyName));
        }
        return entity;
    }

    private static Map<String, Object> mapEntryToMap(ODataEntry entry) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        for (Map.Entry property : entry.getProperties().entrySet()) {
            if (property.getValue() instanceof ODataFeed) {
                ODataFeed feedExpand = (ODataFeed)property.getValue();
                ArrayList<Map<String, Object>> allChildren = new ArrayList<Map<String, Object>>();
                for (ODataEntry feedEntry : feedExpand.getEntries()) {
                    allChildren.add(ODataConnectivityUtil.mapEntryToMap(feedEntry));
                }
                finalResult.put((String)property.getKey(), allChildren);
                continue;
            }
            if (property.getValue() instanceof ODataEntry) {
                ODataEntry entryFeed = (ODataEntry)property.getValue();
                finalResult.put((String)property.getKey(), ODataConnectivityUtil.mapEntryToMap(entryFeed));
                continue;
            }
            finalResult.put((String)property.getKey(), property.getValue());
        }
        return finalResult;
    }

    private static Map<String, Object> addPropertiesToMap(Map<String, Object> complexProperties) {
        HashMap<String, Object> returnedComplexType = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : complexProperties.entrySet()) {
            if (entry.getValue() instanceof Map) {
                returnedComplexType.put(entry.getKey(), ODataConnectivityUtil.addPropertiesToMap((Map)entry.getValue()));
                continue;
            }
            returnedComplexType.put(entry.getKey(), entry.getValue());
        }
        return returnedComplexType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkHttpStatus(HttpResponse response, ErrorResultHandler<?> errorHandler) throws ODataException {
        int httpStatusCode;
        if (errorHandler == null) {
            errorHandler = new ODataExceptionInternalResultHandler();
        }
        if (400 <= (httpStatusCode = response.getStatusLine().getStatusCode()) && httpStatusCode <= 599) {
            String fullResponse = "";
            try {
                if (response.getEntity() != null) {
                    fullResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("OData service response: " + fullResponse + ".");
                }
            }
            catch (IOException e) {
                fullResponse = "Failed to load error page from OData service: " + e.getMessage() + ".";
            }
            finally {
                HttpClientUtils.closeQuietly((HttpResponse)response);
            }
            if (errorHandler instanceof ODataExceptionInternalResultHandler) {
                throw errorHandler.createError(fullResponse, response, httpStatusCode);
            }
            throw errorHandler.createError(fullResponse, null, httpStatusCode);
        }
    }

    private static void checkHttpResponseForCSRF(HttpResponse response, ErrorResultHandler<?> errorHandler) throws ODataException {
        if (errorHandler == null) {
            errorHandler = new ODataExceptionInternalResultHandler();
        }
        int httpStatusCode = response.getStatusLine().getStatusCode();
        Header csrfHeader = response.getFirstHeader(CSRF_HEADER);
        if (httpStatusCode == 405 && csrfHeader != null) {
            return;
        }
        ODataConnectivityUtil.checkHttpStatus(response, errorHandler);
    }

    public static void closeQuietly(HttpResponse httpResponse, HttpRequestBase request) {
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        request.releaseConnection();
    }

    @Deprecated
    public static void safeCloseHttpResponse(HttpResponse httpResponse) {
        if (httpResponse != null) {
            HttpEntity entity = httpResponse.getEntity();
            try {
                InputStream instream;
                if (entity != null && entity.isStreaming() && (instream = entity.getContent()) != null) {
                    instream.close();
                }
            }
            catch (IOException ex) {
                logger.info("IOException while closing HttpResponse entity.getContent()");
            }
            catch (IllegalStateException e) {
                logger.info("IllegalStateException while closing HttpResponse entity.getContent()");
            }
        }
    }

    public static InputStream getObjectStream(Object entity) {
        InputStream inputStream = null;
        inputStream = entity instanceof String ? new ByteArrayInputStream(((String)entity).getBytes(StandardCharsets.UTF_8)) : (InputStream)entity;
        return inputStream;
    }

    public static String withSeparator(String separator, String ... parts) {
        StringBuilder result = new StringBuilder();
        for (String s : parts) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            s = StringUtils.prependIfMissing((String)s, (CharSequence)separator, (CharSequence[])new CharSequence[0]);
            s = StringUtils.removeEnd((String)s, (String)separator);
            result.append(s);
        }
        return result.toString();
    }
}

