/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.slf4j.Logger;

class ODataRequestExecutor {
    private static final Logger logger = CloudLoggerFactory.getLogger(ODataRequestExecutor.class);
    @NonNull
    private HttpClient httpClient;
    @NonNull
    private final URI uri;
    private ErrorResultHandler<?> errorHandler = null;
    private Map<String, String> headers = null;
    private String contentType = "application/json";

    public HttpResponse execute() throws ODataException {
        HttpResponse response = null;
        try {
            response = this.initializeConnection();
            ODataConnectivityUtil.checkHttpStatus(response, this.errorHandler);
            return response;
        }
        catch (IllegalArgumentException e) {
            HttpClientUtils.closeQuietly((HttpResponse)response);
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Failed to execute " + this.toString() + ".", e);
        }
    }

    private HttpResponse initializeConnection() throws ODataException {
        HttpGet request = new HttpGet(this.uri);
        if (StringUtils.isNotEmpty((CharSequence)this.contentType)) {
            request.setHeader("Accept", this.contentType);
            if (this.headers != null) {
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    request.setHeader(header.getKey(), header.getValue());
                }
            }
        }
        try {
            return this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Failed to execute " + this.toString() + ".", e);
        }
    }

    @ConstructorProperties(value={"httpClient", "uri"})
    public ODataRequestExecutor(@NonNull HttpClient httpClient, @NonNull URI uri) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.httpClient = httpClient;
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestExecutor)) {
            return false;
        }
        ODataRequestExecutor other = (ODataRequestExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpClient this$httpClient = this.httpClient;
        HttpClient other$httpClient = other.httpClient;
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        URI this$uri = this.uri;
        URI other$uri = other.uri;
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        ErrorResultHandler<?> this$errorHandler = this.errorHandler();
        ErrorResultHandler<?> other$errorHandler = other.errorHandler();
        if (this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler)) {
            return false;
        }
        Map<String, String> this$headers = this.headers();
        Map<String, String> other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$contentType = this.contentType;
        String other$contentType = other.contentType;
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODataRequestExecutor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpClient $httpClient = this.httpClient;
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        URI $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        ErrorResultHandler<?> $errorHandler = this.errorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        Map<String, String> $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $contentType = this.contentType;
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    public ErrorResultHandler<?> errorHandler() {
        return this.errorHandler;
    }

    public ODataRequestExecutor errorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public ODataRequestExecutor headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }
}

