/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataUpdateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.impl.ODataUpdateRequestImpl;
import com.sap.cloud.servicesdk.prov.jacksonutil.JacksonMapper;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ODataUpdateRequestBuilder {
    private String serviceName;
    private String entitySetName;
    private Map<String, Object> body = null;
    private Map<String, Object> keys;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> destinationRelevantHeaders = new HashMap<String, String>();
    private boolean cacheMetadata = false;
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private boolean isCacheRefresh = false;

    private ODataUpdateRequestBuilder(String serviceName, String entitySetName, Map<String, Object> keys) {
        this.serviceName = serviceName;
        this.entitySetName = entitySetName;
        this.keys = keys;
    }

    public static ODataUpdateRequestBuilder withEntity(String serviceName, String entitySetName, Map<String, Object> keys) {
        return new ODataUpdateRequestBuilder(serviceName, entitySetName, keys);
    }

    public ODataUpdateRequestBuilder withHeader(String key, String value) {
        return this.withHeader(key, value, false);
    }

    public ODataUpdateRequestBuilder withHeader(String key, String value, boolean passInAllRequests) {
        if (passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        if (key.equals("SAP-PASSPORT") && !passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        this.headers.put(key, value);
        return this;
    }

    @Deprecated
    public ODataUpdateRequestBuilder withBody(Map<String, Object> entityData) {
        return this.setBody(entityData);
    }

    public ODataUpdateRequestBuilder enableMetadataCache() {
        this.cacheMetadata = true;
        return this;
    }

    public ODataUpdateRequestBuilder enableMetadataCache(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
        this.cacheMetadata = true;
        return this;
    }

    public ODataUpdateRequestBuilder withCacheRefresh() {
        this.isCacheRefresh = true;
        return this;
    }

    public ODataUpdateRequestBuilder withMetadata(URL metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
        return this;
    }

    public ODataUpdateRequestBuilder withBodyAsMap(Map<String, Object> entityData) {
        return this.setBody(entityData);
    }

    public ODataUpdateRequestBuilder withErrorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    private ODataUpdateRequestBuilder setBody(Map<String, Object> entityData) {
        this.body = entityData;
        return this;
    }

    public ODataUpdateRequest build() {
        ODataUpdateRequestImpl updateRequest = new ODataUpdateRequestImpl(this.serviceName, this.entitySetName, this.keys, this.body, this.errorHandler, this.headers, this.destinationRelevantHeaders, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        return updateRequest;
    }

    public ODataUpdateRequestBuilder withBodyAs(Object pojoData) {
        ObjectMapper mapper = JacksonMapper.getMapper();
        HashMap pojoInMap = (HashMap)mapper.convertValue(pojoData, HashMap.class);
        this.setBody(pojoInMap);
        return this;
    }
}

