/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;

class StringConstructedTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger logger = CloudLoggerFactory.getLogger(StringConstructedTypeAdapterFactory.class);

    StringConstructedTypeAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        for (Constructor<?> c : rawType.getConstructors()) {
            Class<?>[] ts = c.getParameterTypes();
            if (ts.length != 1 || !String.class.isAssignableFrom(ts[0])) continue;
            return new StringConstructedTypeAdapter(rawType, c);
        }
        return null;
    }

    private static final class StringConstructedTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Class<? super T> rawType;
        private final Constructor<?> constructor;

        public void write(JsonWriter out, T value) throws IOException {
        }

        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            try {
                String value = reader.nextString();
                return this.rawType.cast(this.constructor.newInstance(value));
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to instantiate String based type: " + this.rawType.getName(), (Throwable)e);
                }
                return null;
            }
        }

        @ConstructorProperties(value={"rawType", "constructor"})
        public StringConstructedTypeAdapter(Class<? super T> rawType, Constructor<?> constructor) {
            this.rawType = rawType;
            this.constructor = constructor;
        }
    }
}

