/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.impl;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataCreateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataCreateResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.GuavaMetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.MetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.internal.EdmWithCSRF;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.StringEntity;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmAssociationSet;
import org.apache.olingo.odata2.api.edm.EdmAssociationSetEnd;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.ep.DeserializerProperties;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.client.api.ep.EntityStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataCreateRequestImpl
implements ODataCreateRequest {
    private static Logger logger = LoggerFactory.getLogger(ODataCreateRequestImpl.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private static MetadataCache metadataCache = new GuavaMetadataCache();
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private Boolean entityCreated = false;
    String location = null;
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String CONTENTTYPE_ATOM_XML = "application/xml";
    private String serviceName;
    private String entitySet;
    private Map<String, Object> body;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers;
    private Map<String, String> destinationRelevantHeaders;
    private Boolean cacheMetadata;
    private String navigationProperty = null;
    private Map<String, Object> srcKeyMap = null;
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private Boolean isCacheRefresh;

    public ODataCreateRequestImpl(String serviceName, String entitySetName, Map<String, Object> body, String navigationProperty, Map<String, Object> srcKeyMap, ErrorResultHandler<?> errorHandler, Map<String, String> headers, Map<String, String> destinationRelevantHeaders, Boolean cacheMetadata, URL metadataFilePath, CacheKey cacheKey, Boolean isCacheRefresh) {
        this.serviceName = serviceName;
        this.entitySet = entitySetName;
        this.body = body;
        this.srcKeyMap = srcKeyMap;
        this.navigationProperty = navigationProperty;
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.cacheMetadata = cacheMetadata;
        this.metadataFilePath = metadataFilePath;
        this.cacheKey = cacheKey;
        this.isCacheRefresh = isCacheRefresh;
    }

    public ODataCreateRequestImpl(String serviceName, String entitySetName, Map<String, Object> body, ErrorResultHandler<?> errorHandler, Map<String, String> headers, Map<String, String> destinationRelevantHeaders, Boolean cacheMetadata, URL metadataFilePath, CacheKey cacheKey, boolean isCacheRefresh) {
        this.serviceName = serviceName;
        this.entitySet = entitySetName;
        this.body = body;
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.cacheMetadata = cacheMetadata;
        this.metadataFilePath = metadataFilePath;
        this.cacheKey = cacheKey;
        this.isCacheRefresh = isCacheRefresh;
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getEntitySet() {
        return this.entitySet;
    }

    Map<String, Object> getBody() {
        return this.body;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    String getNavigationProperty() {
        return this.navigationProperty;
    }

    @Override
    public ODataCreateResult execute(String destinationName) throws ODataException {
        logger.debug("Create Called with Destination Name: " + destinationName);
        return this.handleExecute(null, destinationName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataCreateResult getResponseFromLocation(String completeUrl, String destinationName) throws ODataException {
        ODataCreateResult oDataCreateResult;
        HttpResponse httpResponse = null;
        try {
            Edm edm = metadataCache.getEdm(completeUrl, this.getHttpClient(destinationName), this.destinationRelevantHeaders, this.errorHandler, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
            EdmEntitySet eSet = edm.getDefaultEntityContainer().getEntitySet(this.entitySet);
            HttpGet requestGet = new HttpGet(this.location);
            httpResponse = this.getHttpClient(destinationName).execute((HttpUriRequest)requestGet);
            ODataConnectivityUtil.checkHttpStatus(httpResponse, this.errorHandler);
            EntityStream entityStream = new EntityStream();
            entityStream.setContent(httpResponse.getEntity().getContent());
            entityStream.setReadProperties(DeserializerProperties.init().build());
            String contentType = "application/atom+xml";
            if (!httpResponse.getFirstHeader(CONTENT_TYPE).toString().contains(contentType)) {
                contentType = APPLICATION_JSON;
            }
            ODataEntry deepInsResponse = ODataClient.newInstance().createDeserializer(contentType).readEntry(eSet, entityStream);
            oDataCreateResult = new ODataCreateResult(httpResponse, deepInsResponse.getProperties());
        }
        catch (IOException e1) {
            try {
                HttpClientUtils.closeQuietly(httpResponse);
                throw new ODataException(null, "IOException", e1);
                catch (EdmException | EntityProviderException e12) {
                    HttpClientUtils.closeQuietly(httpResponse);
                    throw new ODataException(ODataExceptionType.RESPONSE_DESERIALIZATION_FAILED, "Error during serialization of input payload. " + e12.getMessage(), e12);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        return oDataCreateResult;
    }

    private boolean isNavigationFlow() {
        return this.navigationProperty != null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ODataCreateResult create(HttpClient httpClient) throws ODataException {
        ODataCreateResult oDataCreateResult;
        EdmEntitySet eSet;
        String serviceUri = this.serviceName;
        String entitySetName = this.entitySet;
        String completeUrl = null;
        completeUrl = serviceUri + "/" + entitySetName;
        HttpResponse httpResponse = null;
        String contentType = APPLICATION_JSON;
        Edm edm = null;
        ODataResponse response = null;
        Entity entity = null;
        EdmWithCSRF edmWithCSRF = null;
        try {
            edmWithCSRF = ODataConnectivityUtil.readMetadataWithCSRF(serviceUri, httpClient, this.destinationRelevantHeaders, this.errorHandler, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        }
        catch (IOException e1) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", e1);
        }
        if (edmWithCSRF == null || edmWithCSRF.getEdm() == null) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", null);
        }
        edm = edmWithCSRF.getEdm();
        EdmEntityType childEntityType = null;
        EdmEntitySet targetEtySet = null;
        EdmNavigationProperty navigationProperty = null;
        boolean isNavigationFlow = this.isNavigationFlow();
        try {
            eSet = edm.getDefaultEntityContainer().getEntitySet(entitySetName);
            if (eSet == null) {
                throw new ODataException(ODataExceptionType.INVALID_ENTITY_NAME, "No entity with name " + entitySetName + " in the OData service", null);
            }
            EdmEntityType entityType = eSet.getEntityType();
            if (isNavigationFlow) {
                navigationProperty = this.getNavigationProperty(eSet);
            }
            if (navigationProperty != null) {
                childEntityType = this.getTargetEntityType(edm, eSet, navigationProperty);
                targetEtySet = this.getTargetEntitySet(edm, eSet, navigationProperty);
            }
            entity = childEntityType != null ? ODataConnectivityUtil.addPropertiesToEntity(this.body, childEntityType) : ODataConnectivityUtil.addPropertiesToEntity(this.body, entityType);
            completeUrl = this.handleNavigation(completeUrl, entityType);
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
        HttpPost requestPost = new HttpPost(completeUrl);
        requestPost.setHeader("x-csrf-token", edmWithCSRF.getCsrfToken());
        requestPost.setHeader(CONTENT_TYPE, contentType);
        requestPost.setHeader(ACCEPT_HEADER, contentType);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            requestPost.setHeader(header.getKey(), header.getValue());
        }
        entity.setWriteProperties(EntitySerializerProperties.serviceRoot((URI)URI.create(serviceUri)).build());
        try {
            eSet = targetEtySet != null ? targetEtySet : eSet;
            response = ODataClient.newInstance().createSerializer(contentType).writeEntry(eSet, entity);
        }
        catch (EntityProviderException e) {
            throw new ODataException(ODataExceptionType.INPUT_DATA_SERIALIZATION_FAILED, "Error during serialization of input payload. " + e.getMessage(), e);
        }
        byte[] contentArray = null;
        try {
            InputStream inputStream = ODataConnectivityUtil.getObjectStream(response.getEntity());
            String entityString = null;
            if (inputStream != null) {
                entityString = this.getEntityString(inputStream);
                this.closeStream(inputStream);
            }
            StringEntity postEntity = new StringEntity(entityString, UTF_8);
            requestPost.setEntity((HttpEntity)postEntity);
            httpResponse = httpClient.execute((HttpUriRequest)requestPost);
            if (httpResponse.getStatusLine().getStatusCode() == 201) {
                this.entityCreated = true;
                this.location = httpResponse.getFirstHeader("Location").getValue();
            }
            ODataConnectivityUtil.checkHttpStatus(httpResponse, this.errorHandler);
            contentArray = IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent());
            EntityStream entityStream = new EntityStream();
            entityStream.setContent((InputStream)new ByteArrayInputStream(contentArray));
            entityStream.setReadProperties(DeserializerProperties.init().build());
            ODataEntry deepInsResponse = ODataClient.newInstance().createDeserializer(contentType).readEntry(eSet, entityStream);
            oDataCreateResult = new ODataCreateResult(httpResponse, deepInsResponse.getProperties());
        }
        catch (EntityProviderException e) {
            block23: {
                ODataCreateResult oDataCreateResult2;
                try {
                    ODataEntry deepInsResponse;
                    if (contentArray == null) break block23;
                    InputStream contentStream = null;
                    try {
                        String contentStr = new String(contentArray, StandardCharsets.UTF_8);
                        contentStr = contentStr.replaceFirst("\\[", "");
                        int lastIndex = contentStr.lastIndexOf("]");
                        contentStr = contentStr.substring(0, lastIndex) + contentStr.substring(lastIndex + 1);
                        contentStream = IOUtils.toInputStream((String)contentStr, (Charset)StandardCharsets.UTF_8);
                        EntityStream entityStream = new EntityStream();
                        entityStream.setContent(contentStream);
                        entityStream.setReadProperties(DeserializerProperties.init().build());
                        deepInsResponse = ODataClient.newInstance().createDeserializer(contentType).readEntry(eSet, entityStream);
                        this.closeStream(contentStream);
                    }
                    catch (EntityProviderException e1) {
                        try {
                            throw new ODataException(ODataExceptionType.RESPONSE_DESERIALIZATION_FAILED, "Error while deserializing response. " + e.getMessage(), e);
                        }
                        catch (Throwable throwable) {
                            this.closeStream(contentStream);
                            throw throwable;
                        }
                    }
                    oDataCreateResult2 = new ODataCreateResult(httpResponse, deepInsResponse.getProperties());
                }
                catch (Throwable throwable) {
                    ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)requestPost);
                    throw throwable;
                }
                ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)requestPost);
                return oDataCreateResult2;
            }
            throw new ODataException(ODataExceptionType.RESPONSE_DESERIALIZATION_FAILED, "Error while deserializing response. " + e.getMessage(), e);
            catch (IOException | IllegalStateException e2) {
                throw new ODataException(null, e2.getMessage(), e2);
            }
        }
        ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)requestPost);
        return oDataCreateResult;
    }

    private void closeStream(InputStream contentStream) {
        if (contentStream != null) {
            try {
                contentStream.close();
            }
            catch (IOException ex) {
                logger.error("Error while closing the inputstream", (Throwable)ex);
            }
        }
    }

    public EdmNavigationProperty getNavigationProperty(EdmEntitySet srcEtySet) throws EdmException {
        if (this.srcKeyMap == null || this.navigationProperty == null || this.srcKeyMap.isEmpty()) {
            return null;
        }
        EdmEntityType srcEtytype = srcEtySet.getEntityType();
        EdmNavigationProperty navigationProp = (EdmNavigationProperty)srcEtytype.getProperty(this.navigationProperty);
        return navigationProp;
    }

    private EdmEntityType getTargetEntityType(Edm edm, EdmEntitySet srcEtySet, EdmNavigationProperty navigationProp) throws EdmException {
        if (navigationProp == null) {
            return null;
        }
        String toRole = navigationProp.getToRole();
        return navigationProp.getRelationship().getEnd(toRole).getEntityType();
    }

    public EdmEntitySet getTargetEntitySet(Edm edm, EdmEntitySet srcEtySet, EdmNavigationProperty navigationProp) throws EdmException, ODataException {
        EdmAssociationSet associationSet = null;
        associationSet = edm.getDefaultEntityContainer().getAssociationSet(srcEtySet, navigationProp);
        if (associationSet == null) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "The association, referred by the navigation property " + navigationProp.getName() + ", is not contained in an association set.");
        }
        EdmAssociationSetEnd end = null;
        if (navigationProp != null) {
            end = associationSet.getEnd(navigationProp.getToRole());
            return end.getEntitySet();
        }
        return null;
    }

    public String handleNavigation(String completeUrl, EdmEntityType entityType) throws EdmException, ODataException {
        if (this.srcKeyMap == null || this.navigationProperty == null || this.srcKeyMap.isEmpty()) {
            return completeUrl;
        }
        return completeUrl + '(' + ODataConnectivityUtil.convertKeyValuesToString(this.srcKeyMap, entityType) + ')' + '/' + this.navigationProperty;
    }

    protected HttpClient getHttpClient(String destinationName) {
        return HttpClientAccessor.getHttpClient((String)destinationName);
    }

    private String getEntityString(InputStream stream) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, Charset.forName(UTF_8)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public ODataCreateResult execute(WithDestinationName withDestinationName) throws ODataException {
        return this.execute(withDestinationName.getDestinationName());
    }

    @Override
    public ODataCreateResult execute(HttpClient providedClient) throws ODataException {
        logger.debug("Create Called with Direct URL");
        return this.handleExecute(providedClient, null);
    }

    private ODataCreateResult handleExecute(HttpClient httpClient, String destinationName) throws ODataException {
        ODataCreateResult result = null;
        HttpClient httpClient2 = httpClient = destinationName == null ? httpClient : this.getHttpClient(destinationName);
        if (this.cacheMetadata.booleanValue()) {
            try {
                result = this.create(httpClient);
            }
            catch (ODataException e) {
                if (e.getODataExceptionType().equals((Object)ODataExceptionType.OTHER) || e.getODataExceptionType().equals((Object)ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED)) {
                    throw e;
                }
                String completeUrl = this.serviceName + "/$metadata";
                this.isCacheRefresh = true;
                if (this.entityCreated.booleanValue() && this.location != null) {
                    return this.getResponseFromLocation(completeUrl, null);
                }
                throw e;
            }
        } else {
            result = this.create(httpClient);
        }
        return result;
    }

    public String toString() {
        return "CREATE " + ODataConnectivityUtil.withSeparator("/", this.serviceName, this.entitySet);
    }
}

