/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.impl;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataUpdateRequest;
import com.sap.cloud.sdk.odatav2.connectivity.ODataUpdateResult;
import com.sap.cloud.sdk.odatav2.connectivity.UpdateMethod;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.GuavaMetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.MetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.internal.EdmWithCSRF;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import com.sap.cloud.sdk.odatav2.connectivity.internal.UrlEncoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataUpdateRequestImpl
implements ODataUpdateRequest {
    private static Logger logger = LoggerFactory.getLogger(ODataUpdateRequestImpl.class);
    private static final String UTF_8 = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static MetadataCache metadataCache = new GuavaMetadataCache();
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String CONTENTTYPE_ATOM_XML = "application/xml";
    private static final String STRING = "String";
    private String serviceName;
    private String entitySetName;
    private Map<String, Object> body;
    private Map<String, Object> keys;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> headers;
    private Map<String, String> destinationRelevantHeaders;
    private Boolean cacheMetadata;
    private URL metadataFilePath;
    private CacheKey cacheKey;
    private boolean isCacheRefresh;

    public ODataUpdateRequestImpl(String serviceName, String entitySetName, Map<String, Object> keys, Map<String, Object> body, ErrorResultHandler<?> errorHandler, Map<String, String> headers, Map<String, String> destinationRelevantHeaders, boolean metadataCache, URL metadataFilePath, CacheKey cacheKey, boolean isCacheRefresh) {
        this.serviceName = serviceName;
        this.entitySetName = entitySetName;
        this.body = body;
        this.keys = keys;
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.cacheMetadata = metadataCache;
        this.metadataFilePath = metadataFilePath;
        this.cacheKey = cacheKey;
        this.isCacheRefresh = isCacheRefresh;
    }

    @Override
    public ODataUpdateResult execute(UpdateMethod updateMethod, String destinationName) throws ODataException {
        logger.debug("Update Called with Destination Name: " + destinationName);
        return this.handleExecute(updateMethod, destinationName, null);
    }

    private ODataUpdateResult handleExecute(UpdateMethod updateMethod, String destinationName, HttpClient httpClient) throws ODataException {
        ODataUpdateResult result = null;
        HttpClient httpClient2 = httpClient = destinationName == null ? httpClient : this.getHttpClient(destinationName);
        if (this.cacheMetadata.booleanValue()) {
            try {
                result = this.update(httpClient, updateMethod);
            }
            catch (ODataException e) {
                if (e.getODataExceptionType().equals((Object)ODataExceptionType.OTHER) || e.getODataExceptionType().equals((Object)ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED)) {
                    throw e;
                }
                this.isCacheRefresh = true;
                result = this.update(httpClient, updateMethod);
            }
        } else {
            result = this.update(httpClient, updateMethod);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ODataUpdateResult update(HttpClient httpClient, UpdateMethod um) throws ODataException {
        String keyPredicateString;
        EdmEntitySet entitySet;
        String serviceUri = this.serviceName;
        String entitySetName = this.entitySetName;
        String completeUrl = null;
        HttpResponse httpResponse = null;
        String contentType = APPLICATION_JSON;
        Edm edm = null;
        ODataResponse response = null;
        Entity entity = null;
        EdmWithCSRF edmWithCSRF = null;
        try {
            edmWithCSRF = ODataConnectivityUtil.readMetadataWithCSRF(serviceUri, httpClient, this.destinationRelevantHeaders, this.errorHandler, this.cacheMetadata, this.metadataFilePath, this.cacheKey, this.isCacheRefresh);
        }
        catch (IOException e) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", e);
        }
        if (edmWithCSRF == null) throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", null);
        if (edmWithCSRF.getEdm() == null) {
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Metadata fetch failed!", null);
        }
        edm = edmWithCSRF.getEdm();
        try {
            entitySet = edm.getDefaultEntityContainer().getEntitySet(entitySetName);
            if (entitySet == null) {
                throw new ODataException(ODataExceptionType.INVALID_ENTITY_NAME, "No entity with name " + entitySetName + " in the OData service", null);
            }
            EdmEntityType entityType = edm.getDefaultEntityContainer().getEntitySet(entitySetName).getEntityType();
            keyPredicateString = this.convertKeyValuesToString(this.keys, entityType);
            entity = ODataConnectivityUtil.addPropertiesToEntity(this.body, entityType);
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", e);
        }
        completeUrl = serviceUri + "/" + entitySetName + '(' + keyPredicateString + ')';
        Object updateRequest = um == UpdateMethod.PATCH ? new HttpPatch(completeUrl) : new HttpPut(completeUrl);
        updateRequest.setHeader("x-csrf-token", edmWithCSRF.getCsrfToken());
        updateRequest.setHeader(CONTENT_TYPE, contentType);
        updateRequest.setHeader(ACCEPT_HEADER, contentType);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            updateRequest.setHeader(header.getKey(), header.getValue());
        }
        entity.setWriteProperties(EntitySerializerProperties.serviceRoot((URI)URI.create(serviceUri)).build());
        try {
            response = ODataClient.newInstance().createSerializer(contentType).writeEntry(entitySet, entity);
        }
        catch (EntityProviderException e) {
            throw new ODataException(ODataExceptionType.INPUT_DATA_SERIALIZATION_FAILED, "Error during serialization of input payload." + e.getMessage(), e);
        }
        try {
            InputStream inputStream = ODataConnectivityUtil.getObjectStream(response.getEntity());
            String entityString = null;
            if (inputStream != null) {
                entityString = this.getEntityString(inputStream);
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("Error while closing the inputstream", (Throwable)e);
                }
            }
            StringEntity postEntity = new StringEntity(entityString, UTF_8);
            updateRequest.setEntity((HttpEntity)postEntity);
            httpResponse = httpClient.execute((HttpUriRequest)updateRequest);
            ODataConnectivityUtil.checkHttpStatus(httpResponse, this.errorHandler);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ODataException(null, "UnsupportedEncodingException", e);
                catch (IOException e2) {
                    throw new ODataException(null, "IOException", e2);
                }
            }
            catch (Throwable throwable) {
                ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)updateRequest);
                throw throwable;
            }
        }
        ODataConnectivityUtil.closeQuietly(httpResponse, (HttpRequestBase)updateRequest);
        return new ODataUpdateResult(httpResponse);
    }

    private String convertKeyValuesToString(Map<String, Object> keys, EdmEntityType entityType) throws EdmException, ODataException {
        String keyPredicateString = "";
        for (Map.Entry<String, Object> e : keys.entrySet()) {
            String convertedValue;
            if (!keyPredicateString.isEmpty()) {
                keyPredicateString = keyPredicateString + ',';
            }
            String key = e.getKey();
            Object value = e.getValue();
            EdmProperty prop = (EdmProperty)entityType.getProperty(key);
            EdmSimpleType type = (EdmSimpleType)prop.getType();
            try {
                if (STRING.equals(type.getName()) && value != null) {
                    value = UrlEncoder.encode(value.toString());
                }
                convertedValue = type.toUriLiteral(type.valueToString(value, EdmLiteralKind.DEFAULT, prop.getFacets()));
            }
            catch (EdmSimpleTypeException e1) {
                throw new ODataException(ODataExceptionType.BAD_KEY_VALUE, e1.getMessage(), e1);
            }
            keyPredicateString = keyPredicateString + key + '=' + convertedValue;
        }
        return keyPredicateString;
    }

    protected HttpClient getHttpClient(String destinationName) {
        return HttpClientAccessor.getHttpClient((String)destinationName);
    }

    private String getEntityString(InputStream stream) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, Charset.forName(UTF_8)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public ODataUpdateResult execute(WithDestinationName withDestinationName) throws ODataException {
        return this.execute(withDestinationName.getDestinationName());
    }

    @Override
    public ODataUpdateResult execute(String destinationName) throws ODataException {
        return this.execute(UpdateMethod.PUT, destinationName);
    }

    @Override
    public ODataUpdateResult execute(UpdateMethod updateMethod, WithDestinationName withDestinationName) throws ODataException {
        return this.execute(updateMethod, withDestinationName.getDestinationName());
    }

    @Override
    public ODataUpdateResult execute(UpdateMethod updateMethod, HttpClient providedClient) throws ODataException {
        logger.debug("Update Called with direct URL");
        return this.handleExecute(updateMethod, null, providedClient);
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getEntitySetName() {
        return this.entitySetName;
    }

    Map<String, Object> getBody() {
        return this.body;
    }

    Map<String, Object> getKeys() {
        return this.keys;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "UPDATE " + ODataConnectivityUtil.withSeparator("/", this.serviceName, this.entitySetName) + " with key " + this.keys.toString();
    }
}

