/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ODataHttpResponseWrapper {
    HttpResponse response;
    protected int responseStatusCode = 0;
    Header[] headers = null;
    protected Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private static final String DELIMITER = ",";
    private static final String SPACE = "\\s*";
    static final Logger log = LoggerFactory.getLogger(ODataHttpResponseWrapper.class);

    public void setResponse(HttpResponse httpResponse) {
        if (httpResponse != null) {
            this.responseStatusCode = httpResponse.getStatusLine().getStatusCode();
            this.headersMap = this.setAllHaders(httpResponse.getAllHeaders());
        }
    }

    public int getHttpStatusCode() {
        return this.responseStatusCode;
    }

    private Map<String, List<String>> setAllHaders(Header[] headers) {
        for (Header header : headers) {
            if (header == null) continue;
            ArrayList<String> headerValueList = new ArrayList<String>();
            String[] arr = header.getValue().trim().split("\\s*,\\s*");
            headerValueList.addAll(Arrays.asList(arr));
            this.headersMap.put(header.getName(), headerValueList.isEmpty() ? null : headerValueList);
        }
        return this.headersMap;
    }

    public Enumeration<String> getHeaderNames() {
        Set<String> headerNames = this.headersMap.keySet();
        return headerNames.size() > 0 ? Collections.enumeration(headerNames) : null;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headersMap;
    }

    public Map<String, List<String>> getHeader(String name) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        String headerName = this.getHeaderName(name);
        if (log.isDebugEnabled()) {
            log.debug("Get first header value for name " + name + ". Returning value for name " + headerName + ".");
        }
        List<String> valueList = this.headersMap.get(headerName);
        headerMap.put(headerName, valueList);
        return headerMap;
    }

    protected String getHeaderName(String name) {
        for (String headerName : this.headersMap.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }
}

