/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.connection;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.cloud.sdk.service.prov.api.connection.JDBCDataSourceParams;
import com.sap.cloud.sdk.service.prov.api.transaction.impl.TransactionHandler;
import com.sap.cloud.sdk.service.prov.api.util.RequestProcessingHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ThreadSafeObjectStore
implements ServletRequestListener {
    static final Logger logger = LoggerFactory.getLogger(ThreadSafeObjectStore.class);
    static ThreadLocal<Connection> connectionForThread = new ThreadLocal();
    static ThreadLocal<JsonNode> csnForThread = new ThreadLocal();
    static ThreadLocal<ByteArrayOutputStream> metadataForThread = new ThreadLocal();

    public static Connection getConnection() {
        try {
            if (connectionForThread.get() == null || connectionForThread.get().isClosed()) {
                ThreadSafeObjectStore.initializeConnection();
            }
        }
        catch (Exception e) {
            logger.error("error getting connection from provider", (Throwable)e);
        }
        return connectionForThread.get();
    }

    private static void initializeConnection() {
        DataSourceParams connectionProvider = RequestProcessingHelper.getConnectionProvider();
        if (connectionProvider != null && connectionProvider instanceof JDBCDataSourceParams) {
            connectionForThread.set(((JDBCDataSourceParams)connectionProvider).getConnection());
        }
    }

    public static void setCsnForCurrentThread(InputStream csnInputStream) {
        try {
            if (csnForThread.get() != null) {
                return;
            }
            JsonNode csnJson = new ObjectMapper().readTree(csnInputStream);
            csnForThread.set(csnJson);
            logger.debug("Csn is being set for the current thread.");
        }
        catch (IOException e) {
            logger.error("Error while reading csn input stream", (Throwable)e);
        }
    }

    public static JsonNode getCsnForCurrentThread() {
        return csnForThread.get();
    }

    public static ByteArrayOutputStream getMetadataForCurrentThread() {
        return metadataForThread.get();
    }

    public static void setMetadataForCurrentThread(ByteArrayOutputStream baos) {
        metadataForThread.set(baos);
    }

    private static void removeConnectionForCurrentThread() {
        if (connectionForThread.get() != null) {
            Connection conn = connectionForThread.get();
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while closing connection", (Throwable)e);
            }
            connectionForThread.remove();
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        TransactionHandler.cleanupTransaction();
        connectionForThread.remove();
        csnForThread.remove();
        metadataForThread.remove();
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }
}

