/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.UnaryExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.impl.FilterNodeInternal;
import com.sap.cloud.sdk.service.prov.api.filter.impl.NodeInfoImpl;
import java.util.Arrays;
import java.util.List;

public class UnaryExpressionNodeImpl
implements UnaryExpressionNode,
FilterNodeInternal {
    private FilterNodeInternal child;
    private NodeInfoImpl nodeInfo;
    private boolean leafUnitNode = false;

    public UnaryExpressionNodeImpl(FilterNodeInternal child, NodeInfoImpl nodeInfo) {
        this.child = child;
        this.nodeInfo = nodeInfo;
        this.leafUnitNode = this.getChildren().stream().filter(node -> node.getKind() == ExpressionOperatorTypes.NODE_KIND.PROPERTY || node.getKind() == ExpressionOperatorTypes.NODE_KIND.LITERAL).findAny().isPresent();
    }

    @Override
    public ExpressionNode getChild() {
        return this.child;
    }

    @Override
    public ExpressionOperatorTypes.NODE_KIND getKind() {
        return ExpressionOperatorTypes.NODE_KIND.UNARY;
    }

    @Override
    public List<FilterNodeInternal> getChildren() {
        return Arrays.asList(this.child);
    }

    @Override
    public String getOperator() {
        return this.nodeInfo.getNodeOperator();
    }

    @Override
    public boolean isLeafUnit() {
        return this.leafUnitNode;
    }

    @Override
    public boolean isCustomNode() {
        return this.nodeInfo.isCustomNode();
    }
}

