/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.sap.cloud.sdk.service.prov.api.connection.ThreadSafeObjectStore;
import com.sap.cloud.sdk.service.prov.api.internal.AdminDataAnnotation;
import com.sap.cloud.sdk.service.prov.api.internal.CSNNotSetException;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationDetails;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSNUtil {
    private static final String DEFINITIONS = "definitions";
    private static final String ELEMENTS = "elements";
    private static final String TYPE = "type";
    private static final String SQL_MAPPING = "@sql_mapping";
    private static final String ODATA_INSERTED = "@odata.on.insert";
    private static final String ODATA_UPDATED = "@odata.on.update";
    private static final String CDS_INSERTED = "@cds.on.insert";
    private static final String CDS_UPDATED = "@cds.on.update";
    private static final String ODATA_COMPUTED = "@Core.Computed";
    private static final String ORDER_DEFAULT = "@Order.default";
    private static final String ODATA_SEARCHABLE = "@Capabilities.SearchRestrictions.Searchable";
    private static final String ODATA_DEFAULT_SEARCH_ELEMENT = "@Search.defaultSearchElement";
    private static final String ODATA_DEFAULT_SEARCH_ELEMENT_WITH_FUZZY = "@Search.fuzzinessThreshold";
    private static final String ODATA_NOW = "now";
    private static final String ODATA_USER = "user";
    private static final String ODATA_HASH = "#";
    private static final String CDS_PERSISTENCE_NAME = "@cds.persistence.name";
    private static final String CSN_NOT_FOUND = "CSN file not found.";
    private static final String DRAFT_ENABLED = "@odata.draft.enabled";
    private static final String KIND = "kind";
    private static final String RESTRICT = "@restrict";
    private static final String GRANT = "grant";
    private static final String CDS_QUERY_LIMIT = "@cds.query.limit";
    private static final String CDS_CONSISTENT_PAGING = "@cds.consistent.paging";
    private static volatile JsonNode staticCsn;
    private static boolean initialized;
    private static Map<String, Map<String, List<String>>> draftTree;
    private static final String DRAFT_NODE = "@Common.DraftNode.PreparationAction";
    private static final String TARGET = "target";
    private static final String REQUIRES = "requires";
    private static final String LOCALIZED = "localized";
    private static final String CDS_TEMPORAL = "@cds.temporal";
    private static final String CDS_VALID = "@cds.valid";
    private static final String CDS_VALID_FROM = "@cds.valid.from";
    private static final String CDS_AUTOEXPOSE = "@cds.autoexpose";
    private static final String CDS_AUTOEXPOSED = "@cds.autoexposed";
    private static Map<String, ArrayList<String>> entitiesAndCompositions;
    private static Map<String, ArrayList<String>> rootEntitiesWithDeltaenabled;
    private static final String DELTA_ENABLED = "@odata.delta.enabled";
    private static final String ASSOCIATION_SPLIT = ".";
    private static final String AGGREGATED_ENTITY = "@Aggregation.ApplySupported.PropertyRestrictions";
    private static final String CDS_COMPOSITION = "cds.Composition";
    private static final String CDS_ASSOCIATION = "cds.Association";
    private static final String ODATA_ETAG = "@odata.etag";
    private static final String CDS_ETAG = "@cds.etag";
    static Logger logger;

    public static boolean isCreatable(String serviceName, String entityName) throws CSNNotSetException {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return true;
        }
        JsonNode insertable = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get("@Capabilities.InsertRestrictions.Insertable");
        return insertable == null || insertable.asText().equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkIfCSNInitialized() throws CSNNotSetException {
        if (staticCsn != null) return;
        Class<CSNUtil> clazz = CSNUtil.class;
        synchronized (CSNUtil.class) {
            if (staticCsn != null) return;
            if (initialized) {
                throw new CSNNotSetException();
            }
            initialized = true;
            InputStream inputStreamCSN = null;
            try {
                inputStreamCSN = CSNUtil.class.getClassLoader().getResourceAsStream("edmx/csn.json");
                if (inputStreamCSN == null) {
                    throw new CSNNotSetException();
                }
                ObjectMapper objectMapper = new ObjectMapper();
                staticCsn = objectMapper.readTree(inputStreamCSN);
                inputStreamCSN.close();
            }
            catch (IOException e) {
                throw new CSNNotSetException();
            }
            finally {
                try {
                    if (inputStreamCSN != null) {
                        inputStreamCSN.close();
                    } else {
                        logger.debug("inputStreamCSN was null");
                    }
                }
                catch (IOException e) {
                    logger.error("Error in closing inputstream for csn parsing in CSNUtil", (Throwable)e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isUpdatable(String serviceName, String entityName) throws CSNNotSetException {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return true;
        }
        JsonNode updatable = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get("@Capabilities.UpdateRestrictions.Updatable");
        return updatable == null || updatable.asText().equals("true");
    }

    public static boolean isDeletable(String serviceName, String entityName) throws CSNNotSetException {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return true;
        }
        JsonNode deletable = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get("@Capabilities.DeleteRestrictions.Deletable");
        return deletable == null || deletable.asText().equals("true");
    }

    public static Map<String, AdminDataAnnotation> getAdminDataMapForCreate(String serviceName, String entityName, boolean userContextPresent) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> adminDataMap = new HashMap<String, AdminDataAnnotation>();
        if (csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName) != null) {
            JsonNode node = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get(ELEMENTS);
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                JsonNode cdsupdateNode;
                JsonNode updateNode;
                JsonNode cdsinsertNode;
                JsonNode insertNode;
                String colName = (String)it.next();
                JsonNode computeNode = node.get(colName).get(ODATA_COMPUTED);
                if (computeNode != null && computeNode.asBoolean()) {
                    adminDataMap.put(colName, AdminDataAnnotation.COMPUTED_FIELD);
                }
                if ((insertNode = node.get(colName).get(ODATA_INSERTED)) != null && insertNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(insertNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((cdsinsertNode = node.get(colName).get(CDS_INSERTED)) != null && cdsinsertNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsinsertNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((updateNode = node.get(colName).get(ODATA_UPDATED)) != null && updateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(updateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((cdsupdateNode = node.get(colName).get(CDS_UPDATED)) == null || cdsupdateNode.get(ODATA_HASH) == null) continue;
                adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsupdateNode.get(ODATA_HASH).asText(), userContextPresent));
            }
        }
        return adminDataMap;
    }

    public static Map<String, AdminDataAnnotation> getAdminDataMapForDeepCreate(String serviceName, String parentEntityName, String entityName, boolean userContextPresent) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> adminDataMap = new HashMap<String, AdminDataAnnotation>();
        if (csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName) != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + parentEntityName).get(ELEMENTS).get(entityName)) != null) {
            JsonNode targetNode = entityNode.get(TARGET);
            JsonNode childNode = csn.get(DEFINITIONS).get(targetNode.asText());
            if (childNode != null) {
                JsonNode node = childNode.get(ELEMENTS);
                Iterator it = node.fieldNames();
                while (it.hasNext()) {
                    JsonNode cdsupdateNode;
                    JsonNode updateNode;
                    JsonNode cdsinsertNode;
                    JsonNode insertNode;
                    String colName = (String)it.next();
                    JsonNode computeNode = node.get(colName).get(ODATA_COMPUTED);
                    if (computeNode != null && computeNode.asBoolean()) {
                        adminDataMap.put(colName, AdminDataAnnotation.COMPUTED_FIELD);
                    }
                    if ((insertNode = node.get(colName).get(ODATA_INSERTED)) != null && insertNode.get(ODATA_HASH) != null) {
                        adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(insertNode.get(ODATA_HASH).asText(), userContextPresent));
                    }
                    if ((cdsinsertNode = node.get(colName).get(CDS_INSERTED)) != null && cdsinsertNode.get(ODATA_HASH) != null) {
                        adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsinsertNode.get(ODATA_HASH).asText(), userContextPresent));
                    }
                    if ((updateNode = node.get(colName).get(ODATA_UPDATED)) != null && updateNode.get(ODATA_HASH) != null) {
                        adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(updateNode.get(ODATA_HASH).asText(), userContextPresent));
                    }
                    if ((cdsupdateNode = node.get(colName).get(CDS_UPDATED)) == null || cdsupdateNode.get(ODATA_HASH) == null) continue;
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsupdateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
            }
        }
        return adminDataMap;
    }

    public static Map<String, AdminDataAnnotation> getAdminDataMapForUpdate(String serviceName, String entityName, boolean userContextPresent) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> adminDataMap = new HashMap<String, AdminDataAnnotation>();
        if (csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName) != null) {
            JsonNode node = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get(ELEMENTS);
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                JsonNode cdscreateNode;
                JsonNode createNode;
                JsonNode cdsupdateNode;
                JsonNode updateNode;
                String colName = (String)it.next();
                JsonNode computeNode = node.get(colName).get(ODATA_COMPUTED);
                if (computeNode != null && computeNode.asBoolean()) {
                    adminDataMap.put(colName, AdminDataAnnotation.COMPUTED_FIELD);
                }
                if ((updateNode = node.get(colName).get(ODATA_UPDATED)) != null && updateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(updateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((cdsupdateNode = node.get(colName).get(CDS_UPDATED)) != null && cdsupdateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsupdateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((createNode = node.get(colName).get(ODATA_INSERTED)) != null && createNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, AdminDataAnnotation.NO_CHANGE);
                }
                if ((cdscreateNode = node.get(colName).get(CDS_INSERTED)) == null || cdscreateNode.get(ODATA_HASH) == null) continue;
                adminDataMap.put(colName, AdminDataAnnotation.NO_CHANGE);
            }
        }
        return adminDataMap;
    }

    public static List<String> getSearchableProperties(String serviceName, String entityName) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        ArrayList<String> searchableProperties = new ArrayList<String>();
        if (csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName)) != null && entityNode.get(ODATA_SEARCHABLE) != null && entityNode.get(ODATA_SEARCHABLE).asBoolean()) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator it = propertyNode.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                JsonNode defaultSearchNode = propertyNode.get(colName).get(ODATA_DEFAULT_SEARCH_ELEMENT);
                if (defaultSearchNode == null || !defaultSearchNode.asBoolean()) continue;
                searchableProperties.add(colName);
            }
            return searchableProperties.isEmpty() ? null : searchableProperties;
        }
        return null;
    }

    public static Map<String, Double> getSearchablePropertiesWithFuzzy(String serviceName, String entityName) {
        HashMap<String, Double> searchableFuzzyProperties = new HashMap<String, Double>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null) {
            JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
            if (entityNode != null && entityNode.get(ODATA_SEARCHABLE) != null && entityNode.get(ODATA_SEARCHABLE).asBoolean()) {
                JsonNode propertyNode = entityNode.get(ELEMENTS);
                Iterator it = propertyNode.fieldNames();
                while (it.hasNext()) {
                    String colName = (String)it.next();
                    JsonNode defaultSearchNode = propertyNode.get(colName).get(ODATA_DEFAULT_SEARCH_ELEMENT_WITH_FUZZY);
                    if (defaultSearchNode == null) continue;
                    searchableFuzzyProperties.put(colName.toLowerCase(), Double.parseDouble(defaultSearchNode.asText()));
                }
                return searchableFuzzyProperties.isEmpty() ? null : searchableFuzzyProperties;
            }
            return null;
        }
        return null;
    }

    public static Set<String> getProperties(String serviceName, String entityName) {
        JsonNode entityNode;
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName)) != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator it = propertyNode.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                String elementType = propertyNode.get(colName).get(TYPE).asText();
                if (elementType == null || elementType.contains("Association") || elementType.contains("Composition")) continue;
                properties.add(colName);
            }
            return properties.isEmpty() ? null : properties;
        }
        return properties;
    }

    private static AdminDataAnnotation getAdminDataAnnotation(String annotation, boolean userContextPresent) {
        switch (annotation) {
            case "now": {
                return AdminDataAnnotation.NOW;
            }
            case "user": {
                if (userContextPresent) {
                    return AdminDataAnnotation.APPLICATION_USER;
                }
                return AdminDataAnnotation.DB_USER;
            }
        }
        return null;
    }

    public static boolean isPlainSqlMapping() {
        String sqlMapping;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        String string = sqlMapping = csn.get(SQL_MAPPING) == null ? null : csn.get(SQL_MAPPING).asText();
        if (sqlMapping != null) {
            return sqlMapping.equals("plain");
        }
        String csnVersion = csn.get("version").get("csn").asText();
        logger.debug("Csn version is " + csnVersion);
        int versionNumber = Integer.parseInt(csnVersion.replaceAll("\\.", ""));
        return versionNumber >= 10;
    }

    public static boolean isHdbcdsMapping() {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        String sqlMapping = csn.get(SQL_MAPPING) == null ? null : csn.get(SQL_MAPPING).asText();
        return sqlMapping != null && sqlMapping.equals("hdbcds");
    }

    public static String getEntityName(String serviceName, String parentEntityName, String associationName) {
        JsonNode propertyNode;
        JsonNode associationNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        String entityName = null;
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + parentEntityName);
        if (entityNode != null && (associationNode = (propertyNode = entityNode.get(ELEMENTS)).get(associationName)) != null && (entityName = associationNode.get(TARGET).asText()) != null && entityName.contains(ASSOCIATION_SPLIT)) {
            entityName = entityName.substring(entityName.lastIndexOf(46) + 1);
        }
        return entityName;
    }

    public static AuthorizationDetails getAuthorizationDetails(String serviceOrEntityName) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceOrEntityName)) != null) {
            return CSNUtil.getAuthorizationDetails(entityNode);
        }
        return null;
    }

    private static AuthorizationDetails getAuthorizationDetails(JsonNode entityNode) {
        HashMap<String, Object> authDetails = new HashMap<String, Object>();
        if (entityNode.get(KIND) != null) {
            if (entityNode.get(KIND).asText().equals("service")) {
                authDetails.put(KIND, entityNode.get(KIND));
                authDetails.put(REQUIRES, entityNode.get("@requires"));
                return CSNUtil.getAuthorizationDetailsPojo(authDetails);
            }
            if (entityNode.get(KIND).asText().equals("entity") || entityNode.get(KIND).asText().equals("view")) {
                authDetails.put(KIND, entityNode.get(KIND));
                JsonNode restrictDetails = entityNode.get(RESTRICT);
                CSNUtil.convertToArray(restrictDetails);
                authDetails.put("restrict", entityNode.get(RESTRICT));
                return CSNUtil.getAuthorizationDetailsPojo(authDetails);
            }
        }
        return null;
    }

    private static void convertToArray(JsonNode restrictDetails) {
        if (null != restrictDetails) {
            for (JsonNode currnetRule : restrictDetails) {
                if (currnetRule.get(GRANT).isArray()) continue;
                String grantStr = currnetRule.get(GRANT).asText();
                ((ObjectNode)currnetRule).remove(GRANT);
                ((ObjectNode)currnetRule).putArray(GRANT).add(grantStr);
            }
        }
    }

    private static AuthorizationDetails getAuthorizationDetailsPojo(Map<String, Object> authDetails) {
        ObjectMapper mapper = new ObjectMapper();
        if (authDetails.get(REQUIRES) instanceof TextNode) {
            authDetails.put(REQUIRES, Arrays.asList(authDetails.get(REQUIRES)));
        }
        AuthorizationDetails pojo = (AuthorizationDetails)mapper.convertValue(authDetails, AuthorizationDetails.class);
        return pojo;
    }

    public static String getPersistenceName(String fqEntityName, String elementName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode elementNode = csn.get(DEFINITIONS).get(fqEntityName);
        if (elementNode == null) {
            return null;
        }
        if (elementName != null) {
            elementNode = elementNode.get(ELEMENTS).get(elementName);
        }
        if (elementNode == null) {
            return null;
        }
        return elementNode.get(CDS_PERSISTENCE_NAME) == null ? null : elementNode.get(CDS_PERSISTENCE_NAME).asText();
    }

    public static boolean isDraftEnabledEntity(String entityName, String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        if (csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName) == null) {
            return false;
        }
        JsonNode draftEnabled = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get(DRAFT_ENABLED);
        return draftEnabled != null && "true".equals(draftEnabled.asText());
    }

    public static boolean isDefaultOrderEnabled(String entityName, String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        JsonNode orderEnabled = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        if (orderEnabled != null) {
            return orderEnabled.get(ORDER_DEFAULT) != null && orderEnabled.get(ORDER_DEFAULT).asText().equals("true");
        }
        return false;
    }

    public static String getCDSDataType(String entityName, String serviceName, String propName) {
        JsonNode entityNode = CSNUtil.getCsn().get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        if (entityNode != null) {
            return entityNode.get(ELEMENTS).get(propName).get(TYPE).asText();
        }
        return null;
    }

    public static JsonNode getCsn() {
        JsonNode csnForThread = ThreadSafeObjectStore.getCsnForCurrentThread();
        if (csnForThread != null) {
            return csnForThread;
        }
        try {
            CSNUtil.checkIfCSNInitialized();
        }
        catch (CSNNotSetException e) {
            logger.error(CSN_NOT_FOUND, (Throwable)e);
        }
        return staticCsn;
    }

    public static boolean isDraftNodeEntity(String entityName, String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        if (csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName) == null) {
            return false;
        }
        JsonNode draftEnabled = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get(DRAFT_NODE);
        return draftEnabled != null && "draftPrepare".equals(draftEnabled.asText());
    }

    public static synchronized Map<String, List<String>> getCompositionTree(final String serviceName, final String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        final JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        Map.Entry<String, JsonNode> rootEntry = new Map.Entry<String, JsonNode>(){

            @Override
            public JsonNode setValue(JsonNode value) {
                return null;
            }

            @Override
            public JsonNode getValue() {
                return entityNode;
            }

            @Override
            public String getKey() {
                return serviceName + CSNUtil.ASSOCIATION_SPLIT + entityName;
            }
        };
        return CSNUtil.constructCompositionTree(rootEntry, serviceName);
    }

    public static synchronized Map<String, List<String>> getDraftTree(String serviceName) {
        if (draftTree != null && draftTree.get(serviceName) != null) {
            return draftTree.get(serviceName);
        }
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, List<String>>();
        }
        Map.Entry root = null;
        JsonNode alldefs = csn.get(DEFINITIONS);
        Iterator nodes = alldefs.fields();
        while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            if (!((String)entry.getKey()).startsWith(serviceName) || ((JsonNode)entry.getValue()).get(DRAFT_ENABLED) == null || !((JsonNode)entry.getValue()).get(DRAFT_ENABLED).asText().equals("true")) continue;
            root = entry;
            break;
        }
        if (root != null && draftTree != null) {
            draftTree.put(serviceName, CSNUtil.constructCompositionTree(root, serviceName));
        }
        return draftTree != null ? draftTree.get(serviceName) : null;
    }

    private static Map<String, List<String>> constructCompositionTree(Map.Entry<String, JsonNode> currentNode, String serviceName) {
        HashMap<String, List<String>> draftTree = new HashMap<String, List<String>>();
        ArrayList<String> compositions = new ArrayList<String>();
        final JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return draftTree;
        }
        for (final JsonNode property : currentNode.getValue().get(ELEMENTS)) {
            if (property.get(TYPE) == null || !property.get(TYPE).asText().equalsIgnoreCase(CDS_COMPOSITION)) continue;
            compositions.add(property.get(TARGET).asText().substring(serviceName.length() + 1));
            Map.Entry<String, JsonNode> compositionNode = new Map.Entry<String, JsonNode>(){

                @Override
                public JsonNode setValue(JsonNode value) {
                    return null;
                }

                @Override
                public JsonNode getValue() {
                    return csn.get(CSNUtil.DEFINITIONS).get(property.get(CSNUtil.TARGET).asText());
                }

                @Override
                public String getKey() {
                    return property.get(CSNUtil.TARGET).asText();
                }
            };
            draftTree.putAll(CSNUtil.constructCompositionTree(compositionNode, serviceName));
        }
        draftTree.put(currentNode.getKey().substring(serviceName.length() + 1), compositions);
        return draftTree;
    }

    public static Long getQueryLimit(String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        JsonNode queryLimit = null;
        if (csn == null) {
            return null;
        }
        if (csn.get(DEFINITIONS).get(serviceName) != null) {
            queryLimit = csn.get(DEFINITIONS).get(serviceName).get(CDS_QUERY_LIMIT);
        }
        if (queryLimit != null) {
            return queryLimit.asLong();
        }
        return null;
    }

    public static synchronized boolean isConsistentPagingEnabled(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        JsonNode orderEnabled = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        if (orderEnabled != null) {
            return orderEnabled.get(CDS_CONSISTENT_PAGING) != null && orderEnabled.get(CDS_CONSISTENT_PAGING).asText().equals("true");
        }
        return false;
    }

    public static List<String> getTemporalEntities(String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        ArrayList<String> temoralList = new ArrayList<String>();
        if (csn == null) {
            return null;
        }
        Iterator nodes = csn.get(DEFINITIONS).fields();
        block0: while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            Iterator FiledsinEachField = ((JsonNode)entry.getValue()).fields();
            while (FiledsinEachField.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)FiledsinEachField.next();
                if (((String)fieldEntry.getKey()).startsWith(ELEMENTS)) {
                    Iterator elementsIterator = ((JsonNode)fieldEntry.getValue()).fields();
                    while (elementsIterator.hasNext()) {
                        Map.Entry element = (Map.Entry)elementsIterator.next();
                        if (!((JsonNode)element.getValue()).toString().contains(CDS_VALID) || !((String)entry.getKey()).startsWith(serviceName)) continue;
                        temoralList.add((String)entry.getKey());
                        break;
                    }
                }
                if (!((String)fieldEntry.getKey()).startsWith(CDS_TEMPORAL)) continue;
                if (!((String)entry.getKey()).startsWith(serviceName)) continue block0;
                temoralList.add((String)entry.getKey());
                continue block0;
            }
        }
        return temoralList;
    }

    public static Boolean isLocalized(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        if (CSNUtil.isDraftEnabledEntity(entityName, serviceName)) {
            return false;
        }
        if (CSNUtil.isDraftNodeEntity(entityName, serviceName)) {
            return false;
        }
        String fqEntityName = serviceName + ASSOCIATION_SPLIT + entityName;
        JsonNode elementNode = csn.get(DEFINITIONS).get(fqEntityName);
        if (elementNode == null) {
            return false;
        }
        String localizedEntityName = "localized." + serviceName + ASSOCIATION_SPLIT + entityName;
        if (csn.get(DEFINITIONS).get(localizedEntityName) == null || elementNode.get(ELEMENTS) == null || elementNode.get(ELEMENTS).size() == 0) {
            return false;
        }
        Iterator elements = elementNode.get(ELEMENTS).elements();
        while (elements.hasNext()) {
            JsonNode property = (JsonNode)elements.next();
            if (property.get(LOCALIZED) == null || !property.get(LOCALIZED).asBoolean() || elementNode.get(ELEMENTS).get(LOCALIZED) == null || elementNode.get(ELEMENTS).get(LOCALIZED).get(TARGET) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyTemporal(String serviceName, String entitySetName) {
        boolean temporal = false;
        List<String> temporalEntityList = CSNUtil.getTemporalEntities(serviceName);
        Map<String, List<String>> compositionTree = CSNUtil.getCompositionTree(serviceName, entitySetName);
        if (!compositionTree.isEmpty()) {
            for (Map.Entry<String, List<String>> id : compositionTree.entrySet()) {
                int i;
                if (id.getKey() != null) {
                    for (i = 0; i < temporalEntityList.size(); ++i) {
                        if (!id.getKey().equalsIgnoreCase(temporalEntityList.get(i).split("\\.")[1])) continue;
                        temporal = true;
                        break;
                    }
                }
                if (id.getValue().isEmpty()) continue;
                block2: for (i = 0; i < temporalEntityList.size(); ++i) {
                    for (int j = 0; j < id.getValue().size(); ++j) {
                        if (!id.getValue().get(j).equalsIgnoreCase(temporalEntityList.get(i).split("\\.")[1])) continue;
                        temporal = true;
                        continue block2;
                    }
                }
            }
        }
        return temporal;
    }

    public static boolean isTemporal(String serviceName, String requestURL) {
        boolean temporal = false;
        List<String> temporalEntityList = CSNUtil.getTemporalEntities(serviceName);
        for (int i = 0; i < temporalEntityList.size(); ++i) {
            if (!requestURL.toLowerCase().contains(temporalEntityList.get(i).split("\\.")[1].toLowerCase())) continue;
            temporal = true;
        }
        return temporal;
    }

    public static boolean isEntityTemporal(String serviceName, String entitySetName) {
        List<String> temporalEntityList = CSNUtil.getTemporalEntities(serviceName);
        Boolean temporal = false;
        for (int i = 0; i < temporalEntityList.size(); ++i) {
            if (!entitySetName.equals(temporalEntityList.get(i).split("\\.")[1])) continue;
            temporal = true;
            break;
        }
        return temporal;
    }

    public static synchronized List<String> getRootEntitiesWithDeltaEnabled(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        if (rootEntitiesWithDeltaenabled.get(serviceName) == null) {
            CSNUtil.initializeMapforDelta(csn, serviceName);
        }
        ArrayList<String> listOfEntitiesToBeUpdated = new ArrayList<String>();
        ArrayList<String> listOfRootEntitiesToBeUpdated = new ArrayList<String>();
        ArrayList<String> rootEntitesForService = rootEntitiesWithDeltaenabled.get(serviceName);
        CSNUtil.updateListofEntitesToBeUpdated(listOfEntitiesToBeUpdated, serviceName + ASSOCIATION_SPLIT + entityName);
        for (int i = 0; i < rootEntitesForService.size(); ++i) {
            for (int j = 0; j < listOfEntitiesToBeUpdated.size(); ++j) {
                if (rootEntitesForService.get(i).compareTo(listOfEntitiesToBeUpdated.get(j)) != 0) continue;
                listOfRootEntitiesToBeUpdated.add(listOfEntitiesToBeUpdated.get(j));
            }
        }
        return listOfRootEntitiesToBeUpdated;
    }

    private static void updateListofEntitesToBeUpdated(ArrayList<String> listOfEntitiesToBeUpdated, String childEntity) {
        for (Map.Entry<String, ArrayList<String>> entry : entitiesAndCompositions.entrySet()) {
            ArrayList<String> listOfChildren = entry.getValue();
            for (String child : listOfChildren) {
                if (!childEntity.equalsIgnoreCase(child)) continue;
                listOfEntitiesToBeUpdated.add(entry.getKey());
                CSNUtil.updateListofEntitesToBeUpdated(listOfEntitiesToBeUpdated, entry.getKey());
            }
        }
        if (listOfEntitiesToBeUpdated.isEmpty() && entitiesAndCompositions.containsKey(childEntity)) {
            listOfEntitiesToBeUpdated.add(childEntity);
        }
    }

    private static void initializeMapforDelta(JsonNode csn, String serviceName) {
        JsonNode definitions = csn.get(DEFINITIONS);
        ArrayList<String> rootEntities = new ArrayList<String>();
        rootEntitiesWithDeltaenabled.put(serviceName, new ArrayList());
        Iterator fieldNames = definitions.fieldNames();
        while (fieldNames.hasNext()) {
            String fielName = (String)fieldNames.next();
            if (!fielName.startsWith(serviceName)) continue;
            rootEntities.add(fielName);
        }
        for (String rootString : rootEntities) {
            if (definitions.get(rootString).get(DELTA_ENABLED) == null || !definitions.get(rootString).get(DELTA_ENABLED).asBoolean()) continue;
            rootEntitiesWithDeltaenabled.get(serviceName).add(rootString);
        }
        for (String entity : rootEntities) {
            ArrayList<String> compositions = new ArrayList<String>();
            if (definitions.get(entity).get(ELEMENTS) == null) continue;
            Iterator iterator = definitions.get(entity).get(ELEMENTS).fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((JsonNode)entry.getValue()).get(TYPE).asText().equals(CDS_COMPOSITION)) continue;
                compositions.add(((JsonNode)entry.getValue()).get(TARGET).asText());
            }
            if (compositions.size() <= 0) continue;
            entitiesAndCompositions.put(entity, compositions);
        }
    }

    public static String getcompositionPath(String serviceName, String root, String element) {
        if (root.equals(element)) {
            return "";
        }
        String path = CSNUtil.getPathtoChild(serviceName + ASSOCIATION_SPLIT + root, serviceName + ASSOCIATION_SPLIT + element);
        if (path == null || path.length() == 0) {
            return null;
        }
        return path;
    }

    private static String getAssociationPropertyNameForTarget(String rootEntity, String entityToBeFound) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode elementNode = csn.get(DEFINITIONS).get(rootEntity);
        if (elementNode == null || elementNode.get(ELEMENTS) == null || elementNode.get(ELEMENTS).size() == 0) {
            return null;
        }
        Iterator elements = elementNode.get(ELEMENTS).fields();
        while (elements.hasNext()) {
            Map.Entry property = (Map.Entry)elements.next();
            if (((JsonNode)property.getValue()).get(TARGET) == null || ((JsonNode)property.getValue()).get(TARGET).asText().compareTo(entityToBeFound) != 0) continue;
            return (String)property.getKey();
        }
        return null;
    }

    public static List<String> getKeys(String serviceName, String element) {
        ArrayList<String> keys = new ArrayList<String>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode elementNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + element);
        if (elementNode == null || elementNode.get(ELEMENTS) == null || elementNode.get(ELEMENTS).size() == 0) {
            return null;
        }
        Iterator elements = elementNode.get(ELEMENTS).fields();
        while (elements.hasNext()) {
            Map.Entry property = (Map.Entry)elements.next();
            if (((JsonNode)property.getValue()).get("key") == null || !((JsonNode)property.getValue()).get("key").asBoolean()) continue;
            keys.add((String)property.getKey());
        }
        return keys;
    }

    public static List<Map<String, String>> getOrderByProperties(String serviceName, String entityName) {
        JsonNode propertyNode;
        JsonNode selectNode;
        JsonNode queryNode;
        ArrayList<Map<String, String>> orderByOptions = new ArrayList<Map<String, String>>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && csn.get(DEFINITIONS) != null && csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName) != null && (queryNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName).get("query")) != null && (selectNode = queryNode.get("SELECT")) != null && (propertyNode = selectNode.get("orderBy")) != null) {
            for (JsonNode property : propertyNode) {
                JsonNode elementNameNode = property.get("ref");
                HashMap<String, String> selectProp = new HashMap<String, String>();
                String propertyName = elementNameNode.get(0).asText();
                String sort = property.get("sort") != null ? property.get("sort").asText() : "asc";
                selectProp.put(propertyName, sort);
                orderByOptions.add(selectProp);
            }
        }
        return orderByOptions;
    }

    public static synchronized boolean isDeltaEnabled(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        List<String> roots = CSNUtil.getRootEntitiesWithDeltaEnabled(serviceName, entityName);
        if (roots != null && roots.size() > 0) {
            return true;
        }
        JsonNode deltaEnabled = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        if (deltaEnabled != null) {
            return deltaEnabled.get(DELTA_ENABLED) != null && deltaEnabled.get(DELTA_ENABLED).asText().equals("true");
        }
        return false;
    }

    private static String getPathtoChild(String startEntity, String childTobeFound) {
        List childEntities = entitiesAndCompositions.get(startEntity);
        if (childEntities == null) {
            return null;
        }
        for (int i = 0; i < childEntities.size(); ++i) {
            String assocName = CSNUtil.getAssociationPropertyNameForTarget(startEntity, (String)childEntities.get(i));
            if (assocName == null) continue;
            if (childTobeFound.compareToIgnoreCase((String)childEntities.get(i)) == 0) {
                return assocName;
            }
            String path = CSNUtil.getPathtoChild((String)childEntities.get(i), childTobeFound);
            if (path == null) {
                if (i != childEntities.size() - 1) continue;
                return null;
            }
            path = assocName + ASSOCIATION_SPLIT + path;
            return path;
        }
        return null;
    }

    public static List<String> getAggregationColumns(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        if (entityNode != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator it = propertyNode.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                if (propertyNode.get(colName).get("@Aggregation.default") == null) continue;
                columnList.add(colName);
            }
        }
        return columnList;
    }

    public static List<String> getAllColumns(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName);
        if (entityNode != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator iterator = propertyNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (CDS_COMPOSITION.equalsIgnoreCase(((JsonNode)entry.getValue()).get(TYPE).asText()) || CDS_ASSOCIATION.equalsIgnoreCase(((JsonNode)entry.getValue()).get(TYPE).asText())) continue;
                columnList.add((String)entry.getKey());
            }
        }
        return columnList;
    }

    public static String getTemporalDataType(String serviceName) {
        Map.Entry fieldEntry;
        Iterator FiledsinEachField;
        Map.Entry entry;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        Iterator nodes = csn.get(DEFINITIONS).fields();
        Iterator nodes1 = csn.get(DEFINITIONS).fields();
        String temporalKey = null;
        boolean breakcondition = false;
        String temporaldatatype = null;
        while (nodes.hasNext()) {
            entry = (Map.Entry)nodes.next();
            FiledsinEachField = ((JsonNode)entry.getValue()).fields();
            while (FiledsinEachField.hasNext()) {
                fieldEntry = (Map.Entry)FiledsinEachField.next();
                if (!((String)fieldEntry.getKey()).startsWith(CDS_TEMPORAL) || fieldEntry.getValue() == null || !((JsonNode)fieldEntry.getValue()).toString().contains("{") || !((JsonNode)fieldEntry.getValue()).toString().contains("}") || !((JsonNode)fieldEntry.getValue()).toString().contains(":")) continue;
                String parsedValue = ((JsonNode)fieldEntry.getValue()).toString().replace("{", "").replaceAll("}", "").split(":")[1];
                temporalKey = parsedValue.substring(1, parsedValue.length() - 1);
                break;
            }
            if (temporalKey == null) continue;
            break;
        }
        while (nodes1.hasNext()) {
            entry = (Map.Entry)nodes1.next();
            FiledsinEachField = ((JsonNode)entry.getValue()).fields();
            block3: while (FiledsinEachField.hasNext()) {
                Map.Entry property;
                Iterator propertyIterator;
                Map.Entry element;
                fieldEntry = (Map.Entry)FiledsinEachField.next();
                Iterator elementsIterator = null;
                if (!((String)fieldEntry.getKey()).startsWith(ELEMENTS)) continue;
                elementsIterator = ((JsonNode)fieldEntry.getValue()).fields();
                if (temporalKey != null) {
                    while (elementsIterator.hasNext()) {
                        element = (Map.Entry)elementsIterator.next();
                        if (((String)entry.getKey()).startsWith(serviceName) && ((String)element.getKey()).toString().equals(temporalKey)) {
                            propertyIterator = ((JsonNode)element.getValue()).fields();
                            while (propertyIterator.hasNext()) {
                                property = (Map.Entry)propertyIterator.next();
                                if (!((String)property.getKey()).toString().startsWith(TYPE)) continue;
                                temporaldatatype = ((JsonNode)property.getValue()).asText();
                                breakcondition = true;
                                break;
                            }
                        }
                        if (!breakcondition) continue;
                        continue block3;
                    }
                    continue;
                }
                while (elementsIterator.hasNext()) {
                    element = (Map.Entry)elementsIterator.next();
                    if (((String)entry.getKey()).startsWith(serviceName) && ((JsonNode)element.getValue()).toString().contains(CDS_VALID_FROM)) {
                        propertyIterator = ((JsonNode)element.getValue()).fields();
                        while (propertyIterator.hasNext()) {
                            property = (Map.Entry)propertyIterator.next();
                            if (!((String)property.getKey()).toString().startsWith(TYPE)) continue;
                            temporaldatatype = ((JsonNode)property.getValue()).asText();
                            breakcondition = true;
                            break;
                        }
                    }
                    if (!breakcondition) continue;
                    continue block3;
                }
            }
        }
        return temporaldatatype;
    }

    public static boolean isAutoExposedAndAutoExpose(String entityName, String serviceName) {
        JsonNode node;
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (node = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName)) != null) {
            return node.get(CDS_AUTOEXPOSED) != null && node.get(CDS_AUTOEXPOSE) != null;
        }
        return false;
    }

    public static boolean isAutoExposed(String entityName, String serviceName) {
        JsonNode node;
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (node = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName)) != null) {
            return node.get(CDS_AUTOEXPOSED) != null && node.get(CDS_AUTOEXPOSE) == null;
        }
        return false;
    }

    public static boolean isAggregatedEntity(String serviceName, String entityName) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        return csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + ASSOCIATION_SPLIT + entityName)) != null && entityNode.get(AGGREGATED_ENTITY) != null && entityNode.get(AGGREGATED_ENTITY).asBoolean();
    }

    public static String getEtagProperty(String fullyQualifiedEntityName) {
        String result = null;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode entityNode = csn.get(DEFINITIONS).get(fullyQualifiedEntityName);
        if (entityNode == null) {
            return null;
        }
        Iterator itr = entityNode.get(ELEMENTS).fields();
        while (itr != null && itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            JsonNode property = (JsonNode)entry.getValue();
            if ((property.get(ODATA_ETAG) == null || !property.get(ODATA_ETAG).asBoolean()) && (property.get(CDS_ETAG) == null || !property.get(CDS_ETAG).asBoolean())) continue;
            result = (String)entry.getKey();
            break;
        }
        return result;
    }

    public static String getNameSpace(String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        String nameSpace = "";
        Iterator nodes = csn.get(DEFINITIONS).fields();
        while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            if (!((String)entry.getKey()).endsWith(entityName)) continue;
            nameSpace = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(entityName) - 1);
            break;
        }
        return nameSpace;
    }

    static {
        initialized = false;
        draftTree = new HashMap<String, Map<String, List<String>>>();
        entitiesAndCompositions = new HashMap<String, ArrayList<String>>();
        rootEntitiesWithDeltaenabled = new HashMap<String, ArrayList<String>>();
        logger = LoggerFactory.getLogger(CSNUtil.class);
    }
}

