/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.request;

import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.MessageContainer;
import com.sap.cloud.sdk.service.prov.api.locale.impl.LocaleTypeResolver;
import com.sap.cloud.sdk.service.prov.api.request.MessageContainerImpl;
import com.sap.cloud.sdk.service.prov.api.request.Request;
import com.sap.cloud.sdk.service.prov.api.request.RequestContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericRequest {
    static final Logger log = LoggerFactory.getLogger(Request.class);
    protected MessageContainer messageContainer;
    protected EntityMetadata entityMetadata;
    protected String httpMethod;
    protected RequestContext requestContext;
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Locale locale;
    protected String serviceName;
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final String DELIMITER = "-";

    protected Map<String, List<String>> initialiseHeaders(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.headers.put(entry.getKey(), entry.getValue());
        }
        String header = this.getHeader(ACCEPT_LANGUAGE);
        this.messageContainer = new MessageContainerImpl(this.getLocale(header));
        if (header != null) {
            header = LocaleTypeResolver.getLanguage(header);
        }
        this.locale = this.getLocale(header);
        return this.headers;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<String> getHeaderNames() {
        Set<String> headerNames = this.headers.keySet();
        return headerNames.size() > 0 ? Collections.enumeration(headerNames) : null;
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> valueList;
        String headerName = this.getHeaderName(name);
        if (log.isDebugEnabled()) {
            log.debug("Get header value for name " + name + ". Returning value for name " + headerName + ".");
        }
        return (valueList = this.headers.get(headerName)) == null ? null : Collections.enumeration(valueList);
    }

    public String getHeader(String name) {
        List<String> valueList;
        String headerName = this.getHeaderName(name);
        if (log.isDebugEnabled()) {
            log.debug("Get first header value for name " + name + ". Returning value for name " + headerName + ".");
        }
        return (valueList = this.headers.get(headerName)) == null ? null : (valueList.size() > 0 ? valueList.get(0) : null);
    }

    public boolean containsHeader(String name) {
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found header name " + name + " as name " + headerName + " in header names.");
            }
            return true;
        }
        return false;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    protected String getHeaderName(String name) {
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    private Locale getLocale(String acceptLanguage) {
        Locale locale = null;
        if (acceptLanguage == null || "".equals(acceptLanguage.trim()) || "*".equals(acceptLanguage.trim())) {
            locale = new Locale("en", "US");
        } else {
            int tokenCount = 0;
            String language = "";
            String country = "";
            String variant = "";
            if (acceptLanguage.indexOf(DELIMITER) != -1) {
                language = acceptLanguage.substring(0, acceptLanguage.indexOf(DELIMITER));
                acceptLanguage = acceptLanguage.substring(acceptLanguage.indexOf(DELIMITER) + 1);
                ++tokenCount;
                if (acceptLanguage.indexOf(DELIMITER) != -1) {
                    country = acceptLanguage.substring(0, acceptLanguage.indexOf(DELIMITER));
                    ++tokenCount;
                    if ((acceptLanguage = acceptLanguage.substring(acceptLanguage.indexOf(DELIMITER) + 1)) != null && !"".equals(acceptLanguage.trim())) {
                        variant = acceptLanguage;
                        ++tokenCount;
                    }
                } else {
                    country = acceptLanguage.substring(0);
                    ++tokenCount;
                }
            } else {
                language = acceptLanguage;
                ++tokenCount;
            }
            if (tokenCount == 3) {
                locale = new Locale(language, country, variant);
            } else if (tokenCount == 2) {
                locale = new Locale(language, country);
            } else if (tokenCount == 1) {
                locale = new Locale(language);
            }
        }
        return locale;
    }

    public MessageContainer getMessageContainer() {
        if (this.messageContainer == null) {
            this.messageContainer = new MessageContainerImpl(this.locale);
        }
        return this.messageContainer;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

